const is_firefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;
const isIE = 0;

const delay = 1000;
let xmlhttp = false;
let empty_cnt;

// get best/appropriate xmlhttprequest object
if (isIE) {
    try {
        xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
    } catch (e) {
        try {
            xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
        } catch (E) {
            xmlhttp = false;
        }
    }
} else {
    xmlhttp = false;
}
// now go with std (non IE) xmlhttp
if (!xmlhttp && typeof XMLHttpRequest != 'undefined') {
    try {
        xmlhttp = new XMLHttpRequest();
    } catch (e) {
        xmlhttp = false;
    }
}

function send_xmlhttp_request(url, funct) {
    xmlhttp.open("GET", url, true);
    if (!isIE)
        xmlhttp.overrideMimeType('text/plain');
    xmlhttp.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
    if (!funct) funct = function () {
    };
    xmlhttp.onreadystatechange = funct;
    xmlhttp.send(null);
}

function gotStatus(data) {
    /*
     * not found http error <?xml  ?
     */
    if (data.substr(0, 2) === "<?") return;

    if (data !== "") {
        processStatusData(data);
    } else {
        //did not get response, stop polling and report error
        // stop sending requests
        // send_xmlhttp_request("/cgi-bin/sip.cgi?get_status=1",0);
    }
    setTimeout("getStatus()", delay);
}

function getStatus() {
    if (xmlhttp) {
        function reply() {
            if (xmlhttp.readyState === 4) {
                gotStatus(xmlhttp.responseText);
            }
        }

        send_xmlhttp_request("/cgi-bin/command.cgi?get_player_status=1", reply);
    }
}

function startStatusPolling() {
    empty_cnt = 0;
    setTimeout("getStatus()", delay);
}

function processStatusData(statusData) {
    const state = statusData;
    try {
        const jsonObj = JSON.parse(statusData);
        document.getElementById('player_state').innerHTML = jsonObj.app_state;
    } catch (e) {
        document.getElementById('player_state').innerHTML = "n/a";
    }
}

function processThreshold() {
    const slider = document.getElementById("threshold");
    const threshold = slider.value;
    sendSingleCommand('set_threshold=' + threshold)
}

function processCallId() {
    const field = document.getElementById("call_uri");
    const call_uri = field.value;
    sendSingleCommand('make_call=' + call_uri)
}
