/**
 *  Function to include HTMLs files.
 *  To include a HTML file, define in the place code like:
 *  <div flexa-include-html="content_to_include.html"></div>
 *
 *  You must to call this method on load document
 *
 */
function flexaIncludeHTML(callbackFunction) {
    let elemByTag, scanningElem, fileToInclude, xhttp;
    elemByTag = document.getElementsByTagName("*");
    for (let i = 0; i < elemByTag.length; i++) {
        scanningElem = elemByTag[i];
        fileToInclude = scanningElem.getAttribute("flexa-include-html");
        if (fileToInclude) {
            xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function () {
                if (this.readyState === 4) {
                    if (this.status === 200) {
                        scanningElem.innerHTML = this.responseText;
                        scanningElem.removeAttribute("flexa-include-html");
                        scanningElem.setAttribute("www-data-source", fileToInclude);
                        flexaIncludeHTML(callbackFunction);
                        // console.log("Flexa Include \"" + fileToInclude + "\"");
                        flexaAddCollapsablePanelsHandlers();
                    }
                }
            };
            xhttp.open("GET", fileToInclude, true);
            xhttp.send();
            return;
        }
    }
    if (callbackFunction) {
        callbackFunction();
    }
}


/**
 * Get a file using ajax. NOTE: this method is synchronous.
 * @param url
 * @param asAsync
 * @param callback
 */
function flexaReadJsonFile(url, asAsync, callback) {
    const rawFileRequest = new XMLHttpRequest();
    rawFileRequest.overrideMimeType("application/json");
    rawFileRequest.open("GET", url, asAsync);
    rawFileRequest.onreadystatechange = function () {
        if (rawFileRequest.readyState === 4 && rawFileRequest.status === 200) {
            callback(rawFileRequest.responseText);
        }
    };
    rawFileRequest.send(null);
}


/**
 * Send a flexa command to backend
 * @param command
 */
function sendSingleCommand_NEW(command) {
    const xhttp = new XMLHttpRequest();
    xhttp.open("GET", "/cgi-bin/command.cgi?" + command, true);
    xhttp.send();
}


/**
 * Deprecated...
 * @param cmd
 */
function sendSingleCommand(cmd) {
    const randomActNo = Math.floor(Math.random() * 1001);
    // use fake img to send data without reloading
    document.images["senddataimg"].src = "/cgi-bin/command.cgi?" + cmd + "&" + randomActNo;
}


/**
 * Send a http get request asynchronously
 * @param cgiName
 * @param params
 */
function flexaSendXMLHttpGetRequest(cgiName, params) {
    const xhttp = new XMLHttpRequest();
    xhttp.open("GET", cgiName + "?" + params, true);
    xhttp.send();
}


/**
 * Handler for Collapsable panel
 * @private
 */
function _panelClickHandler() {
    this.classList.toggle("panel-header-active");
    const panel = this.nextElementSibling;
    if (panel.style.maxHeight) {
        panel.style.maxHeight = null;
    } else {
        panel.style.maxHeight = panel.scrollHeight + "px";
    }
}


/**
 * Insert handles on collapsable panels containing class "panel-header"
 */
function flexaAddCollapsablePanelsHandlers() {
    // console.log("flexaAddCollapsablePanelsHandlers...");
    const acc = document.getElementsByClassName("panel-header");
    let i;
    for (i = 0; i < acc.length; i++) {
        // This is javascript. Grant that we have only one listener.
        acc[i].removeEventListener("click", _panelClickHandler);
        acc[i].addEventListener("click", _panelClickHandler);
        // console.log("flexaAddCollapsablePanelsHandlers add click handler...");
        if (acc[i].getAttribute("is_open") === "true") {
            acc[i].click();
            acc[i].removeAttribute("is_open");
        }
    }
}


/**
 * Update the panel height contain the given element.
 * Must be called every time that content grows height.
 * @param contentElem
 */
function flexaUpdatePanelHeightForElem(contentElem) {
    let deep = 0;
    let parentElem = contentElem.parentElement;
    while (parentElem && deep <= 5) {
        if (parentElem.getAttribute("class") && parentElem.getAttribute("class").includes("panel-body")) {
            const panelHeaderElem = parentElem.previousElementSibling;
            panelHeaderElem.click();
            panelHeaderElem.click();
            return;
        }
        parentElem = parentElem.parentElement;
        deep++;
    }
}


/**
 * Represent a date in ISO format with time zone
 * @param date
 * @returns {string}
 */
function flexaDateToIsoStringWithTZ(date) {
    let tzo = -date.getTimezoneOffset(),
        dif = tzo >= 0 ? ' +' : ' -',
        pad = function (num) {
            let norm = Math.floor(Math.abs(num));
            return (norm < 10 ? '0' : '') + norm;
        };
    return date.getFullYear() +
        '-' + pad(date.getMonth() + 1) +
        '-' + pad(date.getDate()) +
        ' ' + pad(date.getHours()) +
        ':' + pad(date.getMinutes()) +
        ':' + pad(date.getSeconds()) +
        dif + pad(tzo / 60) +
        ':' + pad(tzo % 60);
}


/**
 * Send the master volume value to backend and set the volume in alsamixer
 */
function onMasterVolumeChange() {
    let masterVolumeSlider = document.getElementById("master-vol");
    if (masterVolumeSlider) {
        let masterVolumeSliderValue = document.getElementById("master-vol-value");
        if (masterVolumeSliderValue) {
            masterVolumeSliderValue.classList.remove("slider-is-moving");
        }
        let volume = masterVolumeSlider.value;
        const CGI_NAME = "mastervolume.cgi";
        const params = "value=" + volume;
        flexaSendXMLHttpGetRequest("/cgi-bin/" + CGI_NAME, params);
    }
}


/**
 * Send the sonic IP volume value to backend and set the UCI var
 */
function onSonicIpVolumeChange() {
    let sonicIpVolumeSlider = document.getElementById("sonicip-vol");
    if (sonicIpVolumeSlider) {
        let sonicIpVolumeSliderValue = document.getElementById("sonicip-vol-value");
        if (sonicIpVolumeSliderValue) {
            sonicIpVolumeSliderValue.classList.remove("slider-is-moving");
        }
        let volume = sonicIpVolumeSlider.value;
        const CGI_NAME = "sonicipvolume.cgi";
        const params = "value=" + volume;
        flexaSendXMLHttpGetRequest("/cgi-bin/" + CGI_NAME, params);
    }
}

/**
 * Update the slider value on the id "<GIVEN_ID>-value"
 * @param sliderId
 */
function onSliderInput(sliderId) {
    let slider = document.getElementById(sliderId);
    if (slider) {
        let volume = slider.value;
        let sliderValue = document.getElementById(sliderId + "-value");
        sliderValue.classList.add("slider-is-moving");
        sliderValue.innerHTML = volume + "%";
    }
}