// Lics stuff


function flexaGetAndDisplayLics() {
    const licContainerElem = document.getElementById('lic_placeholder');
    if (licContainerElem) {
        const URL = '/cgi-bin/getLicenses.cgi';
        const xmlHttp = new XMLHttpRequest();
        xmlHttp.onreadystatechange = function () {
            if (this.readyState === 4) {
                if (this.status === 200) {
                    _displayLics(xmlHttp.responseText, licContainerElem);
                } else {
                    licContainerElem.innerText = "No licenses installed";
                    console.log("Error getting licenses.")
                }
            }
        }
        xmlHttp.open("GET", URL, true);
        xmlHttp.send(null);
    } else  {
        console.log("No container element for lics.");
    }
}


/**
 * Render lics in a element
 * @param licsTxt
 * @param containerElem HtmlElement to populate with lics
 * @private
 */
function _displayLics(licsTxt, containerElem)   {
    try {
        const licsJson = JSON.parse(licsTxt);
        let allLicsHtml = ""
        if (licsJson.length > 0) {
            licsJson.forEach(function (lic) {
                let htmlBuilder = _buildLicenseHtml(lic);
                allLicsHtml += htmlBuilder;
                allLicsHtml += "\n";
            })
            if (containerElem) {
                containerElem.innerHTML = allLicsHtml;
                flexaUpdatePanelHeightForElem(containerElem);
            } else {
                console.error("Container element for lics not found");
            }
        } else {
            containerElem.innerText = "No licenses installed";
        }
    } catch (e) {
        containerElem.innerText = "No licenses installed";
    }
}


/**
 * Lics date parser (2020)
 * @param dateStr
 * @returns {string}
 * @private
 */
function _dateStr2IsoConverter(dateStr)    {
    let pattern = /(\d{1,2})\/(\d{1,2})\/(\d{4})/;
    let date = new Date(dateStr.replace(pattern,'$3-$2-$1'));
    return flexaDateToIsoStringWithTZ(date);
}


/**
 * Lics panel template
 * @param lic
 * @returns {string}
 * @private
 */
function _buildLicenseHtml(lic){
    return `
        <div class="section1">
            <table class="labelValue">
                <colgroup>
                    <col class="label">
                    <col class="value">
                </colgroup>
                <tbody>
                    <tr>
                        <td class="label">Name</td>
                        <td class="value">${lic.name}</td>
                    </tr>
                    <tr>
                        <td class="label">Status</td>
                        <td class="value">${lic.status}</td>
                    </tr>
                    <tr>
                        <td class="label">Issue date</td>
                        <td class="value">${_dateStr2IsoConverter(lic.issue_date)}</td>
                    </tr>
                    <tr>
                        <td class="label">Expire date</td>
                        <td class="value">${_dateStr2IsoConverter(lic.expire_date)}</td>
                    </tr>
                    <tr>
                        <td class="label">ID</td>
                        <td class="value">${lic.identifier}</td>
                    </tr>
                    <tr>
                        <td class="label">Features</td>
                        <td class="value">${lic.features.replace("lic=[", "").replace("]", "")}</td>
                    </tr>
                    <tr>
                        <td class="label">Signature</td>
                        <td class="value">${lic.validFlag}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    `
}

// Endpoint to obtain the lics
const LIC_ENDPOINT = "/cgi-bin/getLicenses.cgi";

// Sources configuration
let licsJson;

/**
 * Obtain a lics using ajax. NOTE: this method is synchronous.
 */
function _getLics() {
    if (!licsJson) {
        flexaReadJsonFile(LIC_ENDPOINT, false, function (content) {
            licsJson = JSON.parse(content);
            // console.log("lics:", licsJson);
        });
    }
    return licsJson;
}


/**
 * Validate Lic feature match from string
 * @param feature
 * @returns {boolean} has feature
 */
function flexaLicHasFeature(feature) {
    const lics = _getLics();
    // Iterate lics
    for (let l = 0; l < lics.length; l++) {
        if (lics[l].features) {
            let allFeatures = lics[l].features.replace("lic=[", "").replace("]", "");
            // Isolate features
            let features = allFeatures.split(",");
            // Iterate features
            for (let f = 0; f < features.length; f++) {
                // Feature match
                if (features[f].trim() === feature) {
                    return true;
                }
            }
        }
    }
    return false;
}
