<% . /usr/local/lib/cgi/haserl.sh ; check_instances status_ui.cgi %>
<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>

<html lang="en_US">
<head>
    <title>Status</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/css/flexa.css" rel="stylesheet" type="text/css">
    <link href="/css/status.css" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/flexa_tools.js"></script>
    <script type="text/javascript" src="/javascript/flexa_lics.js"></script>
    <script type="text/javascript" src="/javascript/status.js"></script>

    <% [ ! -f /usr/local/www/current/app/javascript/app_status.js ] && echo -n '<!-- ' %>
    <script type="text/javascript" src="/app/javascript/app_status.js"></script>
    <% [ ! -f /usr/local/www/current/app/javascript/app_status.js ] && echo -n ' -->' %>
</head>

<body onload="flexaIncludeHTML(); flexaGetAndDisplayLics(); flexaAddCollapsablePanelsHandlers(); renderMassStorageDevicesTable('mass-storage-devices')" style="max-width: 600px;">

    <h2>System Status</h2>

    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_top.cgi ] && echo -n '<!-- ' %>
    <div flexa-include-html="/app/cgi-bin/app_status_top.cgi"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_top.cgi ] && echo -n ' -->' %>

    <div class="panel-header" is_open="true">Device information</div><div class="panel-body"><div class="panel-content">
        <table class="labelValue">
            <colgroup>
                <col class="label">
                <col class="value">
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">Hardware type</td>
                    <td class="value"><% print_device_type %> (ID <% print_hw_type_id %>)</td>
                </tr>
                <tr>
                    <td class="label">IPAM type</td>
                    <td class="value"><% print_ipam_type %> (ID <% print_module_type_id %>)</td>
                </tr>
                <tr>
                    <td class="label">MAC address</td>
                    <td class="value"><% print_mac_addr %></td>
                </tr>
                <tr>
                    <td class="label">IP address</td>
                    <td class="value"><% print_ip_addr %></td>
                </tr>
                <tr>
                    <td class="label">Netmask</td>
                    <td class="value"><% print_netmask %></td>
                </tr>
                <tr>
                    <td class="label">Default gateway</td>
                    <td class="value"><% print_default_gw %></td>
                </tr>
                <tr>
                    <td class="label">DNS servers</td>
                    <td class="value"><% print_dns_servers %></td>
                </tr>
                <tr>
                    <td class="label">Firmware </td>
                    <td class="value">Flexa</td>
                </tr>
                <tr>
                    <td class="label">Firmware version</td>
                    <td class="value"><% print_fw_version %></td>
                </tr>
                <tr>
                    <td class="label">Application</td>
                    <td class="value"><% uci -q get flexa_app.AppParam.app_name %> </td>
                </tr>
                <tr>
                    <td class="label">Application version</td>
                    <td class="value"> <% uci -q get flexa_app.AppParam.version %> </td>
                </tr>
                <tr>
                    <td class="label">Linux kernel version</td>
                    <td class="value"> <% print_kernel_version %></td>
                </tr>
                <tr>
                    <td class="label">Bootloader version</td>
                    <td class="value"> <% print_bootloader_version %></td>
                </tr>
            </tbody>
        </table>
    </div></div></div>

    <div class="panel-header">System</div><div class="panel-body"><div class="panel-content">
        <table class="labelValue">
            <colgroup>
                <col class="label">
                <col class="value">
            </colgroup>
            <tbody>
                <tr>
                    <td class="label">System time</td>
                    <td class="value"><% date %></td>
                </tr>
                <tr>
                    <td class="label">Uptime</td>
                    <td class="value"><% print_uptime %></td>
                </tr>
            </tbody>
        </table>
    </div></div></div>


    <div class="panel-header">Licenses</div><div class="panel-body"><div class="panel-content">
        <div id="lic_placeholder">
           verifying licences...
        </div>
    </div></div></div>


    <div class="panel-header">Mass storage devices</div><div class="panel-body"><div class="panel-content">
        <div  id="mass-storage-devices"></div>
    </div></div></div>

    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_bottom.cgi ] && echo -n '<!-- ' %>
    <div flexa-include-html="/app/cgi-bin/app_status_bottom.cgi"></div>
    <% [ ! -f /usr/local/www/current/app/cgi-bin/app_status_bottom.cgi ] && echo -n ' -->' %>

    <br>
    <img class="send-cmd-img" id="send_cmd_img" src="">
</body>
</html>
