<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<%
APP_NAME=`jq -j .name /mnt/data/package/manifest.json`
if [ -z "${APP_NAME}" ]; then
    APP_NAME="Flexa";
fi

DEVICE_ALIAS=$(echo "$(uci get flexa_app.AppParam.device_alias)")
if [ ! -z "${DEVICE_ALIAS}" ]; then
    APP_NAME="${APP_NAME} | ${DEVICE_ALIAS}"
fi
%>

<html lang="en_US">
<head>
    <title><% echo -n $APP_NAME %></title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <meta name="theme-color" content="#000000">
    <!-- <meta name="viewport" content="width=device-width, initial-scale=0.5, shrink-to-fit=no"> -->
    <!-- FAVICON related -->
    <link rel="apple-touch-icon" sizes="180x180" href="/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/favicon/favicon-16x16.png">
    <link rel="manifest" href="/favicon/site.webmanifest">
    <link rel="mask-icon" href="/favicon/safari-pinned-tab.svg" color="#6F6F6F">
    <meta name="msapplication-TileColor" content="#6F6F6F">
    <meta name="theme-color" content="#FFFFFF">
    <link href="/css/flexa.css" rel="stylesheet" type="text/css">
</head>

<body class="main-menu">

    <table class="main-menu" cellpadding="0" cellspacing="0">

        <tr id="navbar" class="main-menu">
            <th class="main-menu">
                <ul id="main-menu" class="main-menu">
                </ul>
            </th>
            <th id="end_navbar" class="main-menu main-menu-red main-menu-hdwr-info">
                <% print_device_type %>&nbsp;MAC: <% print_mac_addr %>&nbsp;FW <% print_fw_version %>
            </th>
        </tr>

        <tr>
            <td id="app_name_span" class="product">
                <% echo -n "${APP_NAME}" %>
                <% if [ $MANIFEST_OK -ne 0 ]; then echo "<span style=\"font-size: 14; color: red; padding-left: 1em;\"> Application was not made to work with current Flexa image and it might not work.</span>"; fi %>
            </td>
            <td align="right" style="padding-right: 8px;">
                <a href="https://www.barix.com" target="_blank">
                    <img src="/images/barix.png">
                </a>
            </td>
        </tr>

        <tr class="navbar-separator">
            <td id="navbar_separator" class="main-menu"</td>
            <td class="main-menu-red"></td>
        </tr>
    </table>

    <div class="section1">

        <h2>Sound card selection</h2>
        <br><br>

        <%
            if [ "$FORM_soundcard" != "" ] ; then
                echo "master.card=${FORM_soundcard}" > /etc/barix/soundcard.conf
                echo "master.device=plug:dmixer" >> /etc/barix/soundcard.conf
                echo "master.control=Master" >> /etc/barix/soundcard.conf
                echo '
                    <table cellpadding="4" cellspacing="4">
                        <tr>
                            <td class="label">Sound card <b>'$FORM_soundcard'</b> selected.</td>
                        </tr>
                    </table>
                '
            else
                echo '
                    <form action="select-sound-card.cgi" method="get">
                        <table cellpadding="4" cellspacing="4">
                            <tr>
                                <td class="label">Select Soundcard:</td>
                                <td class="value">';
                                    echo -n "<select name=\"soundcard\" class=\"longText\">"
                                    regex="card\s+([0-9]+):\s*(.*),.*";
                                    aplay -l | grep -e "^card " | while read -r LINE ; do
                                        if [[ $LINE =~ $regex ]]
                                        then
                                            CARD_ID="${BASH_REMATCH[1]}"
                                            CARD_NAME="${BASH_REMATCH[2]}"
                                            echo "<option value=\"${CARD_ID}\">[${CARD_ID}] ${CARD_NAME}</option>";
                                        fi
                                    done
                                    echo -n "</select>"
                                    echo '
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td><button type="submit">Submit</button></td>
                            </tr>
                        </table>
                    </form>
                '
            fi
        %>
    </div>
</body>