<% . /usr/local/lib/cgi/haserl.sh ; check_instances network_ui.cgi %>
<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>

<html lang="en_US">
<head>
    <title>Network</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/css/flexa.css" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/sys/js/util.js"></script>
    <script type="text/javascript" src="/javascript/flexa_tools.js"></script>

    <% [ ! -f /usr/local/www/current/app/javascript/app_settings.js ] && echo -n '<!-- ' %>
    <script type="text/javascript" src="/app/javascript/app_settings.js"></script>
    <% [ ! -f /usr/local/www/current/app/javascript/app_settings.js ] && echo -n ' -->' %>

    <script language="javascript">

        var is_firefox = navigator.userAgent.toLowerCase().indexOf('firefox') > -1;

        /* password check */
        function validatePassword() {
            var password = document.getElementById("pwd_set");
            var password_chk = document.getElementById("pwd_chk");
            var ret=false;
            if(password.value != password_chk.value) {
                alert("Passwords don't match! Please correct them before submitting your changes!");
            } else {
                ret=true;
            }
            return ret;
        }

        /* hide html table row */
        function hide_tr(id)    {
            el=document.getElementById(id);
            if (el) el.style.display='none';
        }

        /* show html table row
           Latest version of Firefox use "block" to show previously
           hidden table row when style.display='' is used in JS code
           This causes problems with select options drop down menus
           not being selectable with the mouse, so handle it
           it here differently here */
        function show_tr(id)    {
            el=document.getElementById(id);
            if (el) {
                if (is_firefox) {
                    el.style.display='table-row';
                } else {
                    el.style.display='';
                }
            }
        }

        /* local network params show function */

        function view_network_settings(show_static) {
            if (show_static == "static")    {
                show_tr('ip_addr');
                show_tr('netmask');
                show_tr('gateway');
                show_tr('dns1');
                show_tr('dns2');
                hide_tr('dhcp_name');
            } else {
                hide_tr('ip_addr');
                hide_tr('netmask');
                hide_tr('gateway');
                hide_tr('dns1');
                hide_tr('dns2');
                show_tr('dhcp_name');
            }
            flexaUpdatePanelHeightForElem(ip_addr);
        }

        function initNetworkPage(){
            view_network_settings(document.getElementById('net_proto').value);
            showMicLinein('<% cfg_print_param application.audio.mic_linein %>');
        }


        function showMicLinein(currSelection)   {
            if (currSelection == 'mic') {
                show_tr('mic_boost');
                show_tr('mic_gain');
                show_tr('ad_gain');
            } else {
                hide_tr('mic_boost');
                hide_tr('mic_gain');
                show_tr('ad_gain');
            }
        }

        function checkIntInputValue(elem,minVal,maxVal,defVal)  {
            // get the entered value
            var newValue=elem.value;
            // if not set, use the default
            if ( newValue == "" ) newValue = defVal;
            // the value must be integer number
            var newValNum=parseInt(newValue, 10);
            // ... and in the range of min-max
            if ( newValNum > maxVal ) newValNum = maxVal;
            if ( newValNum < minVal ) newValNum = minVal;
            if ( newValue != newValNum )    {
                elem.value = newValNum;
            }
        }

        function showHideAecTail(aecOpt)    {
            var tailElem=document.getElementById('aec_tail_row');
            if (aecOpt != "disabled")   {
                tailElem.style.display = '';
            } else {
                tailElem.style.display = 'none';
            }
        }

        function checkHostName(elem)    {
            var hostName=elem.value;
            if (!/^[-A-Za-z0-9\.]*$/.test(hostName)){
                    alert('This is a non valid hostname! Characters from A to Z, from a to z, from 0 to 9, . and - only are admitted!');
                    elem.value=elem.defaultValue;
            }
        }

        function showNotification() {
            <%  if [ "$FORM_notification" != "" ] ; then
                    echo -n "notify.notify({message:'$FORM_notification', level:'$FORM_level'});"
                fi
            %>
        }

    </script>

    <!-- Notification Popup -->
    <link rel="stylesheet" href="/notify/css/notify.css">
    <script src="/notify/notify.js"></script>

</head>

<body onload="flexaIncludeHTML(); initNetworkPage(); showNotification(); flexaAddCollapsablePanelsHandlers();" style="max-width: 600px;">

    <form name="settings" action="config.cgi" method="POST">

        <input type="hidden" name="return_page" value="network_ui.cgi">

        <div>
            </br>

            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_top.cgi ] && echo -n '<!-- ' %>
            <div flexa-include-html="/app/cgi-bin/app_settings_top.cgi"></div>
            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_top.cgi ] && echo -n ' -->' %>

            <div class="section1">
                <table class="labelValue">
                     <colgroup>
                         <col class="label">
                         <col class="value">
                     </colgroup>
                     <tbody>
                         <tr>
                            <td class="label">Device Alias</td>
                            <td class="value"><input name="flexa_app.AppParam.device_alias" class="mediumText" value="<% cfg_print_param flexa_app.AppParam.device_alias %>"></td>
                         </tr>
                         <tr>
                             <td class="label">Master Volume</td>
                             <td class="value">
                                <div class="slider-content">
                                    <div class="slider-left">
                                        <input id="master-vol"
                                            class="slider"
                                            type="range" min="0" max="100" step="1"
                                            value="<% cfg_print_param application.audio.volume %>"
                                            name="application.audio.volume"
                                            oninput="onSliderInput('master-vol')"
                                            onchange="onMasterVolumeChange()">
                                    </div>
                                    <div id="master-vol-value" class="slider-right">
                                        <% cfg_print_param application.audio.volume %>%
                                    </div>
                                </div>
                             </td>
                         </tr>
                     </tbody>
                 </table>
            </div>

            <div class="panel-header">Network Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label">
                        <col class="value">
                    </colgroup>
                    <tbody>
                        <tr>
                            <td class="label">Avahi announce</td>
                            <td class="value value-check-button"><% form_print_radio network.avahi.enabled Yes No %> </td>
                        </tr>
                        <tr>
                            <td class="label">SonicIP</td>
                            <td class="value value-check-button"><% form_print_radio network.sonic_ip.enabled Yes No %> </td>
                        </tr>
                        <tr>
                            <td class="label">SonicIP Volume</td>
                            <td class="value">
                                <div class="slider-content">
                                    <div class="slider-left">
                                        <input id="sonicip-vol"
                                            class="slider"
                                            type="range" min="0" max="100" step="1"
                                            value="<% cfg_print_param network.sonic_ip.volume %>"
                                            name="network.sonic_ip.volume"
                                            oninput="onSliderInput('sonicip-vol')"
                                            onchange="onSonicIpVolumeChange()">
                                    </div>
                                    <div id="sonicip-vol-value" class="slider-right">
                                        <% cfg_print_param network.sonic_ip.volume %>%
                                    </div>
                                </div>
                             </td>
                        </tr>
                        <tr>
                            <td class="label">Web Protocol</td>
                            <td class="value">
                                <select class="shortText" id="web_protocol" name="httpd.webserver.protocol">
                                    <option value="http" <% if cfg_string_compare httpd.webserver.protocol http ; then echo -n "selected"; fi %>>HTTP</option>
                                    <option value="https" <% if cfg_string_compare httpd.webserver.protocol https ; then echo -n "selected"; fi %>>HTTPS</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td class="label">DHCP</td>
                            <td class="value">
                                <select class="shortText" id="net_proto" name="network.eth0.proto" onchange="view_network_settings(this.value)">
                                    <option value="dhcp" <% if cfg_string_compare network.eth0.proto dhcp ; then echo -n "selected"; fi %>>Yes</option>
                                    <option value="static" <% if cfg_string_compare network.eth0.proto static ; then echo -n "selected"; fi %>>No</option>
                                </select>
                            </td>
                        </tr>
                        <tr id="ip_addr" >
                            <td class="label">IP Address</td>
                            <td class="value"><input name="network.eth0.ipaddr" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.ipaddr %>" onChange="IPAddrCheck(this,0)"></td>
                        </tr>
                        <tr id="netmask" >
                            <td class="label">Netmask</td>
                            <td class="value"><input name="network.eth0.netmask" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.netmask %>" onChange="NetmaskCheck(this)"></td>
                        </tr>
                        <tr id="gateway" >
                            <td class="label">Gateway IP Address</td>
                            <td class="value"><input name="network.eth0.gateway" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.gateway %>" onChange="IPAddrCheck(this,1)"></td>
                        </tr>
                        <tr id="dns1" >
                            <td class="label">Primary DNS</td>
                            <td class="value"><input name="network.eth0.dns1" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.dns1 %>" onChange="IPAddrCheck(this,1)"></td>
                        </tr>
                        <tr id="dns2" >
                            <td class="label">Alternative&nbsp;DNS</td>
                            <td class="value"><input name="network.eth0.dns2" class="mediumText" maxlength="15" value="<% cfg_print_param network.eth0.dns2 %>" onChange="IPAddrCheck(this,1)"></td>
                        </tr>
                        <!--
                            <tr>
                                <td class="label">Web Server Port</td>
                                <td class="value"><input name="httpd.webserver.port" type="number" class="mediumNumber" maxlength="5" value="<% cfg_print_param httpd.webserver.port %>" onChange="PortCheck(this,1)">
                                </td>
                            </tr>
                        -->
                        <tr id="dhcp_name">
                            <td class="label">DHCP Host Name</td>
                            <td class="value"><input name="network.eth0.dhcpname" class="mediumText" maxlength="32" value="<% cfg_print_param network.eth0.dhcpname %>" onChange="checkHostName(this)"></td>
                        </tr>
                        <tr id="syslog_addr">
                            <td class="label">Syslog Address</td>
                            <td class="value"><input name="syslogd.remote.ipaddr" class="mediumText" maxlength="15" value="<% cfg_print_param syslogd.remote.ipaddr %>" onChange="IPAddrCheck(this,1)"></td>
                        </tr>
                    </tbody>
                </table>
            </div></div></div>

            <div class="panel-header">Time Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label">
                        <col class="value">
                    </colgroup>
                    <tbody>
                        <!--
                            <tr>
                                <td class="label">RTC</td>
                                <td class="value">
                                    <select name="rtc.rtc.enabled" class="shortText">
                                        <option value="true" <% if cfg_string_compare rtc.rtc.enabled true ; then echo -n "selected"; fi %>>enabled</option>
                                        <option value="false" <% if cfg_string_compare rtc.rtc.enabled false ; then echo -n "selected"; fi %>>disabled</option>
                                    </select>
                                </td>
                            </tr>
                        -->
                        <tr id="ntp_servers1">
                            <td class="label">NTP Server 1</td>
                            <td class="value"><input name="ntp.source.server1" class="mediumText" value="<% cfg_print_param ntp.source.server1 %>"></td>
                        </tr>
                        <tr id="ntp_servers2">
                            <td class="label">NTP Server 2</td>
                            <td class="value"><input name="ntp.source.server2" class="mediumText" value="<% cfg_print_param ntp.source.server2 %>"></td>
                        </tr>
                        <tr id="ntp_servers3">
                            <td class="label">NTP Server 3</td>
                            <td class="value"><input name="ntp.source.server3" class="mediumText" value="<% cfg_print_param ntp.source.server3 %>"></td>
                        </tr>
                    </tbody>
                </table>
            </div></div></div>

            <div class="panel-header">Security Settings</div><div class="panel-body"><div class="panel-content">
                <table class="labelValue">
                    <colgroup>
                        <col class="label">
                        <col class="value">
                    </colgroup>
                    <tbody>
                    <tr>
                        <td class="label">Reset Factory Defaults</td>
                        <td class="value value-check-button"><% form_print_radio security.defaults.enabled Enabled Disabled %> </td>
                    </tr>
                    <tr>
                        <td class="label">Update Function</td>
                        <td class="value value-check-button"><% form_print_radio security.update.enabled Enabled Disabled %> </td>
                    </tr>
                    <tr>
                        <td class="label">Reboot Function</td>
                        <td class="value value-check-button"><% form_print_radio security.reset.enabled Enabled Disabled %> </td>
                    </tr>
                    <%
                    if ! cfg_string_compare httpd.webserver.password_set "true" ; then
                        echo -n "
                        <tr>
                            <td class=\"label\">Web UI Password</td>
                            <td class=\"value\">
                                <input name=\"pwd_set\" class=\"smallText\" id=\"pwd_set\" type=password maxlength=\"16\" placeholder=\"Password\">
                                <input id=\"pwd_chk\" class=\"smallText\" type=\"password\" maxlength=\"16\" placeholder=\"Confirm Password\">
                            </td>
                        </tr>
                        "
                    else
                        echo -n "
                        <tr>
                            <td class=\"label\">Web UI Password</td>
                            <td class=\"value\">
                                <input name=\"pwd_old\" class=\"smallText\" type=password maxlength=\"16\" placeholder=\"old password\">
                                <input name=\"pwd_new\" class=\"smallText\" id=\"pwd_set\" type=\"password\" maxlength=\"16\" placeholder=\"new password\">
                                <input id=\"pwd_chk\" class=\"smallText\" type=\"password\" maxlength=\"16\" placeholder=\"confirm password\">
                             </td>
                        </tr>
                        "
                    fi
                    %>

                    </tbody>
                </table>
            </div></div></div>

            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_bottom.cgi ] && echo -n '<!-- ' %>
            <div flexa-include-html="/app/cgi-bin/app_settings_bottom.cgi"></div>
            <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_bottom.cgi ] && echo -n ' -->' %>

            <hr style="width: calc(100vw - 48px); max-width: 600px;">

            <table class="section1 sources" cellspacing="0" cellpadding="3" style="width: 100%;">
                <tbody>
                    <tr>
                        <td align="right">
                            <button class="red" onClick="window.location.reload();" title="Restore settings">Cancel</button>
                            <button class="green" type="submit" target="_self" onClick="return validatePassword();" title="Apply settings">Submit</button>
                        </td>
                    </tr>
                </tbody>
            </table>

        </div>
    </form>
</body>
</html>
