<html lang="en_US">
<head>
    <title>Network Help</title>
    <meta http-equiv="Content-type" content="text/html;charset=UTF-8">
    <link href="/css/flexa.css" rel="stylesheet" type="text/css">
    <script src="/javascript/flexa_tools.js"></script>
</head>

<body class="help" onload=flexaIncludeHTML();>
    <div class="help">
        <h2>Help</h2>
        <h4>Device Alias</h4>
        <p>Define a alias for the device. Useful for distinguishing multiple devices on the same network and browser favorites. Need to reload page to view changes.</p>

        <h3>Network Settings</h3>

        <% [ ! -f /usr/local/www/current/app/app_settings_help_top.html ] && echo -n '<!-- ' %>
        <div flexa-include-html="/app/app_settings_help_top.html"></div>
        <% [ ! -f /usr/local/www/current/app/app_settings_help_top.html ] && echo -n ' -->' %>

        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_top.cgi ] && echo -n '<!-- ' %>
        <div flexa-include-html="/app/cgi-bin/app_settings_help_top.cgi"></div>
        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_top.cgi ] && echo -n ' -->' %>

        <div>
            <h4>Avahi announce</h4>
            <p>
                If set to <em>"yes"</em>, the Avahi announce daemon is activated.<br>
                This daemon implements zero-configuration networking,
                including a system for multicast DNS/DNS-SD service discovery<br>
                Default: <em>"no"</em>
            </p>

            <h4>SonicIP<sup>&reg;</sup></h4>
            <p>
                If set to <em>"yes"</em>, the device will announce its IP address over the audio output.<br>
                Default: <em>"yes"</em>
            </p>

            <h4>SonicIP<sup>&reg;</sup> Volume</h4>
            <p>
                Sets the volume at which the SonicIP<sup>&reg;</sup> will be announced at boot.<br>
                Default: <em>"50 %"</em>
            </p>

            <h4>DHCP</h4>
            <p>
                Select "Yes" for automatic assignment of IP address, Netmask, Gateway and Primary/Alternative DNS.<br>
                Select "No" for manually assigning IP address, Netmask, Gateway and Primary/Alternative DNS.<br>
                <b><em>Note:</em></b> If set to "Static" all fields are mandatory (except Alternative DNS and Syslog Address).<br>
                Default: <em>"Yes"</em>
            </p>

            <h4>DHCP Host Name</h4>
            <p>
                When <em>DHCP</em> is <em>yes</em>, you can optionally set a DHCP Host Name to be sent in the DHCP request.
            </p>

            <h4>Web server port</h4>
            <p>
                Defines the port where the webserver of the Barix Store&amp;Play Device can be reached.<br>
                Default: <em>"80"</em>
            </p>

            <h4>Syslog Address</h4>
            <p>
                Enter the destination IP address for Syslog messages sent by the SYSLOG command.<br>
                <b><em>Note: </em></b>The Syslog messages are not broadcasted, so you need to set explicitly the IP address of your Syslog logging device in order to be able to receive the Syslog messages.
                <br>Disable: <em>"0.0.0.0 (disabled)"</em>
                <br>Default: <em>""</em>
            </p>
        </div>

        <h3>Time Settings</h3>
        <div>
            <p>
                Allows to set up to 3 NTP servers for internet time adjustment.
            </p>
        </div>

        <h3>Security Settings</h3>
        <div>
            <h4>Reboot Function</h4>
            <p>
                Enable or disable the &quot;Reboot&quot; function with the RESET button and from the WEB UI REBOOT tab.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Reset Factory Defaults</h4>
            <p>
                Enable or disable the &quot;Reset Factory Defaults&quot; feature from both web UI &quot;DEFAULTS&quot; tab and device front panel RESET button. In order to revert all settings to factory defaults click on the &quot;Defaults&quot; web UI page, or keep the Reset button pressed for more than 10 seconds. <br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Update Function</h4>
            <p>
                Enable or disable the WEB Update function of the device.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Automatic Remote Update</h4>
            <p>
                Enable or disable the automatic update of the device.<br>
                Please note that the device must be connected to the Internet.<br>
                Default: <em>"enabled"</em>
            </p>

            <h4>Web UI Password</h4>
            <p>
                This group of fields is visible as long as no password is set.<br>
                Enter the <em>admin</em> password (up to 16 characters) both in the "Password" and "Confirm Password" fields, then click the "Submit" button. After the restart you should close the browser window and open a new browser window. You will be asked to supply user name and password. Use the default <em>admin</em> user name and the password that you have just set in order to access the web UI.<br>
            </p>

            <h4>Change Password</h4>
            <p>
                This group of fields is visible as long as a password is set.<br>
                To allow free access (clearing the password) enter the old password and leave the fields "New Password" and "Confirm Password" empty. After the restart you will not be asked for user name and password anymore.
            </p>

        </div>

        <% [ ! -f /usr/local/www/current/app/app_settings_help_bottom.html ] && echo -n '<!-- ' %>
        <div flexa-include-html="/app/app_settings_help_bottom.html"></div>
        <% [ ! -f /usr/local/www/current/app/app_settings_help_bottom.html ] && echo -n ' -->' %>

        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_bottom.cgi ] && echo -n '<!-- ' %>
        <div flexa-include-html="/app/cgi-bin/app_settings_help_bottom.cgi"></div>
        <% [ ! -f /usr/local/www/current/app/cgi-bin/app_settings_help_bottom.cgi ] && echo -n ' -->' %>

        <br>

    </div>

</body>
</html>
