<% . /usr/local/lib/cgi/haserl.sh ; check_instances getMountDevices.cgi %>
<%

# Builds a JSON object with mass storage devices info.
function buildMountDeviceJson() {
    LIST=$(df -h | grep /media/)
    MOUNT_OUTPUT=$(mount)
    JSON="{\"mountedDevices\":[";
    FIRST=1
    while read DEVICE_LINE ; do
        if [ "${FIRST}" == "1" ]; then
            FIRST=0;
        else
            JSON="${JSON},"
        fi
        if [ "$DEVICE_LINE" = "" ];
            then continue;
        fi
        declare -a PARAMS
        PARAMS=(${DEVICE_LINE// / })
        FSTYPE=$(echo "$MOUNT_OUTPUT" | grep "${PARAMS[0]}" | sed 's/.*type \([^ \t]*\).*/\1/g')
        MEDIA=$(echo "${PARAMS[0]}" | sed "s#/dev/mmcblk[0-9]p[0-9]#microSD #g; s#/dev/sd[a-z][0-9]*#USB#g")
        MOUNT_AS=$(echo "$MOUNT_OUTPUT" | grep "${PARAMS[0]}" | sed 's/.*(\([a-z]*\),.*/\1/')
        JSON="${JSON}{\"type\":\"$MEDIA\",\"mountAs\":\"$MOUNT_AS\",\"fsType\":\"$FSTYPE\",\"size\":\"${PARAMS[1]}\",\"used\":\"${PARAMS[2]}\",\"available\":\"${PARAMS[3]}\",\"use\":\"${PARAMS[4]}\",\"mountPoint\":\"${PARAMS[5]}\"}"
    done <<< "$LIST"
    echo -n "${JSON}]}"
}

echo -n $(buildMountDeviceJson);

%>