<% 
. /usr/local/lib/cgi/generic.sh 
. /usr/local/lib/cgi/config.sh


# Extract application name from manifest
APP_NAME=`python /usr/local/www/current/scripts/getManifestProperty.py name`

# Set the parent page title according manifest
function getAppName()   {
	if [ ! -z "${APP_NAME}" ]; then echo -n "${APP_NAME}"; else echo -n "Flexa"; fi
}

DEV_NAME=$(getAppName)
TIME_TAG=$(date +%Y%m%d%H%M%S)
MAC_ADDR=$(cat /sys/class/net/eth0/address | tr "[a-z]" "[A-Z]" | tr ":" "-")

# Make a snapshot of UCIs values
uci show > /var/log/uci.config

cd /var/log
echo "Content-Disposition: attachment; filename=${DEV_NAME}_${MAC_ADDR}_${TIME_TAG}_logs.tar.gz"
print_http_hdr text/plain
tar -cv *  | gzip -c
%>