<% . /usr/local/lib/cgi/generic.sh; config.cgi %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>
<%


# Print the string of the already configured WebUI protocol
function printProtocol() {
  echo -n "$(cfg_print_param httpd.webserver.protocol)://";
}


# print new URL of the refresh page
# call only if address is known (see the above function)
function printHost() {
  if cfg_string_compare network.eth0.proto "dhcp" ; then
    print_ip_addr
  else
    cfg_print_param network.eth0.ipaddr
  fi
  # echo -n ":"
  # cfg_print_param httpd.webserver.port
}


passwd_file="/barix/local/etc/.passwd"

# set new first time password
function digest_password_set() {
	if [[ X"" != X"$1" ]] ; then
		# note: realm must match the one set in /etc/config.d/httpd
		realm="Barix Login"
		hash=`echo -n "admin:$realm:$1" | md5sum | cut -b -32`
		rm -f "$passwd_file"
		echo "admin:$realm:${hash}" >> "$passwd_file"
		cfg_set_param httpd.webserver.password_set "true"
	fi
}


function digest_password_reset() {
	realm="Barix Login"

	if [[ X"" != X"$1" ]] ; then
		temp="admin:$realm:"`echo -n "admin:$realm:$1" | md5sum | cut -b -32`
		echo "temp=$temp" > /var/run/md5.txt
		# the .passwd file may have also user named "user" but in this application 
		# we do care about/use "admin" user only
		line=`cat $passwd_file | grep admin`
		if [[ $temp != *"$line"* ]] ; then
			return 3
		fi
		if [ ! -z $2 ] ; then
			digest_password_set $2
		else
			# disable password now
			cfg_set_param httpd.webserver.password_set "false"
			
			rm -f "$passwd_file"
		fi
	fi
}


# # # # #

# first handle if return page is not set
if [ "$FORM_return_page"X = "X" ] ; then FORM_return_page="index.html"; fi

declare -a pwd_old
declare -S MESSAGES
MAIN_STATUS=-1

# Iterate all FROM variables
while read LINE ; do

	EQUATION=${LINE#FORM_*}
	UCI_KEY=${EQUATION%=*}
	UCI_VAL=${EQUATION#*=}

	case $UCI_KEY in 
		*pwd_set*)
			digest_password_set $UCI_VAL
		;;
		*pwd_old*)
			pwd_old=$UCI_VAL
		;;
		*pwd_new*)
			pwd_new=$UCI_VAL
		;;
	esac

    UCI_OLD_VAL=$(/usr/bin/uci get "$UCI_KEY")

	cfg_set_param "$UCI_KEY" "$UCI_VAL"

    # If UCI was changed
    if [ "${UCI_OLD_VAL}" != "${UCI_VAL}" ]; then

        # Flexa process configuration changes
        # Stdout will show as WebUI waiting messages.
        # Exit status:
        #   0 - Configuration applied normally.
        #   1 - Configuration applied. Service need to be restarted.
        #   9 - Configuration applied. Reboot needed.
        FLEXA_MESSAGE=$(/bin/bash ../scripts/config_uci_process.sh "${UCI_KEY}" "${UCI_OLD_VAL}" "${UCI_VAL}")
        FLEXA_STATUS=$?
        if [[ ! " ${MESSAGES[@]} " =~ " ${FLEXA_MESSAGE} " ]]; then
            MESSAGES+=("$FLEXA_MESSAGE")
        fi
        if (( FLEXA_STATUS > MAIN_STATUS)); then
            MAIN_STATUS=$FLEXA_STATUS
        fi

        # Application Solution post script to process parameters
        POST_APP_SCRIPT=../app/scripts/config_uci_process.sh
        # If a solution has its own config_uci_process.sh
        if [ -f "$POST_APP_SCRIPT" ]; then
            RESULT_MESSAGE=$(/bin/bash "${POST_APP_SCRIPT}" "${UCI_KEY}" "${UCI_OLD_VAL}" "${UCI_VAL}")
            RESULT_STATUS=$?
            if [[ ! " ${MESSAGES[@]} " =~ " ${RESULT_MESSAGE} " ]]; then
                MESSAGES+=("$RESULT_MESSAGE")
            fi
            if (( RESULT_STATUS > MAIN_STATUS)); then
                MAIN_STATUS=$RESULT_STATUS
            fi
        fi
    fi

done <<< $(env | grep FORM_)

if [ ! -z "${pwd_old}" ]; then
	digest_password_reset $pwd_old $pwd_new
	MAIN_STATUS=$?
fi

NOTIF_MESSAGE=""
NOTIF_LEVEL=""
case $MAIN_STATUS in
  1)
    NOTIF_MESSAGE="System services have restarted";;
  3)
    NOTIF_MESSAGE="The old password is incorrect"
    NOTIF_LEVEL="danger"
    ;;
  9)
    NOTIF_MESSAGE="System is rebooting. Please wait 1 min until reload.";;
  *)
    NOTIF_MESSAGE="Configuration applied"
    NOTIF_LEVEL="good"
    ;;
esac

### DEBUG ###
#echo "FLEXA_STATUS=$FLEXA_STATUS" >> /tmp/config_uci.log
#echo "RESULT_STATUS=$RESULT_STATUS" >> /tmp/config_uci.log
#echo "MAIN_STATUS=$MAIN_STATUS" >> /tmp/config_uci.log
#echo "NOTIF_MESSAGE=$NOTIF_MESSAGE" >> /tmp/config_uci.log
### /DEBUG ###

%>

<html lang="en_US">
<head>
    <title>Config</title>
    <link href="/css/flexa.css" rel="stylesheet" type="text/css">
    <script type="text/javascript" src="/javascript/restart-services.js"></script>
    <!-- Notification Popup -->
    <link rel="stylesheet" href="/notify/css/notify.css">
    <script src="/notify/notify.js"></script>
</head>
<%
    case $MAIN_STATUS in
      1)
        echo "<body onload=\"restartingServicesSlideShow('waiting-message', 'waiting-message', '', function () {
            window.location.href = '$FORM_return_page?notification=$NOTIF_MESSAGE';
        } );\" style=\"background-color: #F8F8F8; font-size: 15px; font-weight: normal; font-family: "SourceSansPro", Arial, Helvetica, sans-serif; color: #333333;\">"
        ;;
      2)
        echo "<body onload=\"restartingServicesSlideShow('waiting-message', 'waiting-message', '$(printProtocol)$(printHost)/', function () {
            top.location.href = '$(printProtocol)$(printHost)/';
        } );\" style=\"background-color: #F8F8F8; font-size: 15px; font-weight: normal; font-family: "SourceSansPro", Arial, Helvetica, sans-serif; color: #333333;\">"
        ;;
      9)
        echo "<body onload=\"goToTopUrl('/', 60000);\">"
        ;;
      *)
        echo "<body onload=\"goToUrl('$FORM_return_page?notification=$NOTIF_MESSAGE&level=$NOTIF_LEVEL');\">"
        ;;
    esac
%>

    <div id="waiting-message" style="width: 100%; text-align: center; top: calc(25vh); position: relative;">
        <div id="loading" class="loading-ripple">
            <div></div>
            <div></div>
        </div>
        <div  style="width: 90%; margin: 0 auto; color: #333333; font-family: SourceSansPro, Arial, Helvetica, sans-serif; font-size:19px; font-weight:400; text-align:center;">
            <h3>processing...</h3>
            <p><br/></p>
            <%
                for MSG in "${MESSAGES[@]}"
                do
                    echo -n "<h3>"${MSG}"<h3>"
                done
            %>
        </div>
    </div>
    <%
        if [ "${MAIN_STATUS}" == "9" ]; then
            echo -n "<script>notify.notify({message:'"${NOTIF_MESSAGE}"', level:'warning', autoDismissing: false})</script>";
        fi
    %>
</body>
</html>

<%
    # Save config
    cfg_save

    if [ "${MAIN_STATUS}" == "9" ]; then
        /sbin/reboot
    fi
%>
