<% . /usr/local/lib/cgi/generic.sh ; print_http_hdr %>
<% . /usr/local/lib/cgi/status.sh %>
<% . /usr/local/lib/cgi/config.sh %>
<% 

# adds key:value to the control.json, which is used
# to load web ui parameters at runtime
# params:
#   $1: key 
#   $2: value

CTRLJSON=/mnt/data/package/control.json

add_to_control_json() {

    new_json_pair="{\"$1\":\"$2\"}"

    if [ ! -f "${CTRLJSON}" ] ; then
      echo "creating ${CTRLJSON}"
      echo "{ }" > ${CTRLJSON}
    fi

    if [ ! -f "${CTRLJSON}_new" ] ; then
      echo "creating tmp file"
      touch ${CTRLJSON}_tmp
    fi

    jq --argjson to_add ${new_json_pair} '. + $to_add' < ${CTRLJSON} > ${CTRLJSON}_tmp
    cp ${CTRLJSON}_tmp ${CTRLJSON}
    rm ${CTRLJSON}_tmp

}

if [ "$FORM_get_player_status" != "" ] ; then

    # appl_name=$( uci get flexa_agent.service.appl_name )
    # logger "check status of applciation... ${appl_name}
    python_file=/mnt/data/package/run.py
    lua_file=/mnt/data/package/default.lua

    if [ -f "${python_file}" ]; then
            pid=$( pidof python3 )
            # echo -n "$( pidof python3 )"
    else
            pid=$( pidof lua5.1 )
            #echo -n "$( pidof lua5.1 )"
    fi

    if [ ! -z "$pid" ]; then
      app_state="running"
    else
      app_state="not running"
    fi

    sip_uri=$( uci get flexa_app.AppParam.sip_uri )
    jsonObj="{ \"app_state\":\"${app_state}\"}"

    echo ${jsonObj}
fi


if [ "$FORM_app_stop" != "" ] ; then
    logger "stopping flexa app"
    /etc/init.d/run-flexa stop
fi


if [ "$FORM_app_start" != "" ] ; then
    logger "starting flexa app"
    echo -e $(set -o posix ; set) >> /tmp/run-flexa.log
    /etc/init.d/run-flexa start
fi


if [ "$FORM_reconnect" != "" ] ; then
    logger "reconnect"
    /usr/bin/flexa-agent reset
    /usr/bin/flexa-agent
fi


if [ "$FORM_make_call" != "" ] ; then
    logger "call uri: "$FORM_make_call
    uci set flexa_app.AppParam.make_call_uri=$FORM_make_call
fi


if [ "$FORM_set_threshold" != "" ] ; then
    logger "threshold: "$FORM_set_threshold
    uci set flexa_app.AppParam.threshold=$FORM_set_threshold
    add_to_control_json threshold $FORM_set_threshold
fi

%>


