#!/bin/sh

# Barix utilities for sound control.
# Copyright (C) 2018 Barix AG (http://www.barix.com). All rights reserved.
#
# Dependencies:
#   NONE
#
#  Variables
#   NONE

# Set Playback volume from stored uci variable (application.audio.volume).
#
# Parameters:
#  none
#
# Returns:
#  <ret>: 0 on SUCCESS, error code on failure.

# Include the L400 utilities
LEGACY_HW_TYPE=`qiba-spi-get-production-info.sh -w`
[ -f /usr/bin/qiba-exstreamerl.sh ] && source /usr/bin/qiba-exstreamerl.sh

set_playback_volume() {
	MIXER_VOLUME="Line Out"
	echo "Setting the volume on the board ${MIXER_VOLUME}"
	sound_set_amplifier 1

	PLAYBACK_VOLUME=$(uci get application.audio.volume)
	if [ -z ${PLAYBACK_VOLUME} ]; then
		echo "No valid volume prameter found. Defaulting to 100%";
		PLAYBACK_VOLUME="100%";
	fi

	echo "Setting Playback Volume to ${PLAYBACK_VOLUME} of Mixer Control ${MIXER_VOLUME}."
	/usr/bin/amixer -M -q sset "\"${MIXER_VOLUME}\"" ${PLAYBACK_VOLUME}

	return $?
}

# Set (enable/disable) the amplifier (gpio17).
#
# Parameters:
#  $1: Enable flag (1: Enable, Other: Disable).
#
# Returns:
#  <ret>: 0 on SUCCESS, error code on failure.
sound_set_amplifier() {
	local enable="${1}"
	local gpio17
	local action
	local ret=0

	if [ "x${enable}" = "x1" ]; then
		action="Enable"
		gpio17="1"
	else
		action="Disable"
		gpio17="0"
	fi
	
	if [ $LEGACY_HW_TYPE = "55" ]; then
		echo "sound: ${action} L400 audio outputs ..."
		if [ $gpio17 = "1" ]; then
			gpioexp_audio_out_ipam400 2>/dev/null || ret=$?
		else
			gpioexp_audio_out_mute 2>/dev/null || ret=$?
		fi
		if [ ${ret} -ne 0 ]; then
			echo "sound: ${action} L400 audio outputs ...FAILED (${ret})"
			return ${ret}
		else
			echo "sound: ${action} L400 audio outputs) ...OK"
		fi
	else
		echo "sound: ${action} amplifier (gpio17=${gpio17})..."
		echo "${gpio17}" > /sys/class/gpio/gpio17/value 2>/dev/null || ret=$?
		if [ ${ret} -ne 0 ]; then
			echo "sound: ${action} amplifier (gpio17=${gpio17})...FAILED (${ret})"
			return ${ret}
		else
			echo "sound: ${action} amplifier (gpio17=${gpio17})...OK"
		fi
	fi
	
	
	return 0
}

# Set sound outputs mute on L400.
#
# Returns:
#  <ret>: 0 on SUCCESS, error code on failure.
sound_set_mute() {
    gpioexp_audio_out_mute || return $?
    return 0
}

# Wait for Sonic IP to end.
#
# Parameters:
#  None
#
# Returns:
#  <ret>: 0 on SUCCESS, error code on failure.
sound_wait_sonic_ip() {
	local c=0

	echo "sound: Waiting Sonic IP to end..."
	while [ ${c} -le 32 ]; do
		if [ `/bin/pidof mpg123` ]
		then
			sleep 1
			echo "sound: Waiting Sonic IP to end..."
		else
			echo "sound: Waiting Sonic IP to end...OK."
			return 0
		fi
		((c++))
	done
	echo "sound: Waiting Sonic IP to end...TIMEOUT"
	return 1
}

