# Barix Web UI 
# (c)2012 Barix AG
#
# Functions to handle runtime device status

PATH=/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin
FILE_FACT_INFO=/tmp/factory_info_partition/factory_info
FILE_FACT_INFO_JSON=/tmp/factory_info_partition/factory_info_json

source /usr/bin/jshn.sh


#--------------------- Device information -------------------------

# print date and time
function print_datetime()
{
	date
}

function print_hw_type_id()
{
	hw_id_json=""
	# XML factory info shall have precedence on the legacy one
	if [ -e $FILE_FACT_INFO_JSON ]; then
                HW_INFO=`cat $FILE_FACT_INFO_JSON`
                json_load "$HW_INFO"
                json_select HW_DEVICE
                json_get_var hw_id_json "Product ID"
	fi
	if [ "$hw_id_json" != "" ]; then
		# Do not use "" to remove the trailing spaces if any
		echo -n $hw_id_json
	else
		echo -n "Unknown device type"
	fi
}

# print device type
function print_device_type()
{
	hw_name_json=""
	# XML factory info shall have precedence on the legacy one
	if [ -e $FILE_FACT_INFO_JSON ]; then
                HW_INFO=`cat $FILE_FACT_INFO_JSON`
                json_load "$HW_INFO"
                json_select HW_DEVICE
                json_get_var hw_name_json "Product Name"
	fi
	if [ "$hw_name_json" != "" ]; then
		# Do not use "" to remove the trailing spaces if any
		echo -n $hw_name_json
	else
		echo -n "Unknown device type"
	fi
}

function print_module_type_id()
{
	hw_id_json=""
	# XML factory info shall have precedence on the legacy one
	if [ -e $FILE_FACT_INFO_JSON ]; then
                HW_INFO=`cat $FILE_FACT_INFO_JSON`
                json_load "$HW_INFO"
                json_select HW_DEVICE
                json_get_var hw_id_json "Legacy IPAM Type"
	fi
	if [ "$hw_id_json" != "" ]; then
		# Do not use "" to remove the trailing spaces if any
		echo -n $hw_id_json
	else
		echo -n "Unknown device type"
	fi
}

# print device type
function print_ipam_type()
{
	ipam_name_json=""
	if [ -e $FILE_FACT_INFO_JSON ]; then
                HW_INFO=`cat $FILE_FACT_INFO_JSON`
                json_load "$HW_INFO"
                json_select HW_DEVICE
                json_get_var ipam_name_json "IPAM Name"
	fi
	if [ "$ipam_name_json" != "" ]; then
		# Do not use "" to remove the trailing spaces if any
		echo -n $ipam_name_json
	else
		echo -n "Unknown device type"
	fi
}

# print application version
function print_app_version()
{
	if [ -e /etc/appversion ]; then
               cat /etc/appversion
        else
               echo ""
        fi
}

# prints the bootloader version
function print_fw_version
{
	cat /barix/info/VERSION
}


# prints the bootloader version
function print_bootloader_version
{
	cat /barix/info/BOOTVERSION
}

# prints kernel version
function print_kernel_version()
{
	cat /proc/version
}
#--------------------- System status  -------------------------

# prints system uptime
function print_uptime()
{
#	uptime | sed -n "s/.*up \([^,]*\).*/\1/p"
	uptime=$(</proc/uptime)
	uptime=${uptime%%.*}
	seconds=$(( uptime%60 ))
	minutes=$(( uptime/60%60 ))
	hours=$(( uptime/60/60%24 ))
	days=$(( uptime/60/60/24 ))
	echo "$days days, $hours hours, $minutes minutes, $seconds seconds"
}


#--------------------- Network information -------------------------

# print device MAC address in colon-separated format, capital letters
function print_mac_addr()
{
	cat /sys/class/net/eth0/address | tr "[a-z]" "[A-Z]"
}

# print device IP  address
# optional parameter $1 defines the interface, default is eth0
function print_ip_addr()
{
	if [ $# -lt 1 ] ; then interface=eth0
	else interface="$1"
	fi

	ifconfig "$interface" | sed -n 's/.*inet addr:\([0-9.]\+\).*/\1/p' | tr -d "\\n"
}

# print device netmask
# optional parameter $1 defines the interface, default is eth0
function print_netmask()
{
	if [ $# -lt 1 ] ; then interface=eth0
	else interface="$1"
	fi

	ifconfig "$interface" | sed -n 's/.*Mask:\([0-9.]\+\).*/\1/p' | tr -d "\\n"
}

# print default gateway
# optional parameter $1 defines the interface, default is eth0
function print_default_gw()
{
	if [ $# -lt 1 ] ; then interface=eth0
	else interface="$1"
	fi

	route -n| grep "$interface" | grep "^0.0.0.0" |  awk '{print $2}'
}

# print DHCP name
function print_dhcp_name()
{
	echo -n "DHCP name DUMMY"
}


# prints all DNS servers, one per line
function print_dns_servers()
{
	grep nameserver /etc/resolv.conf | awk '{print $2}'
}


#--------------------- Filesystem info -------------------------
# prints HTML table of mounted storage devices 
# if no media found, prints an error message
# content is similar to df -h
# parameters:
#	$1 = parameters to the HTML table element if media found
#	$2 = message to be printed if nothing found
function print_mount_table()
{
	count=0
	listing=`df -h | grep /media/`
	mount_output=`mount` 

	while read device_line ; do
		# end if there are no lines
		if [ "$device_line" = "" ] ; then continue ; fi
		# import output of df into an array
		# 0: devnode, 1: size, 2: used, 3: available, 4: use, 5: mountpoint
		declare -a params
		params=(${device_line// / })
		fstype=`echo "$mount_output" | grep "${params[0]}" | sed 's/.*type \([^ \t]*\).*/\1/g'`
		media=`echo "${params[0]}" | sed "s#/dev/mmcblk[0-9]p[0-9]#microSD #g; s#/dev/sd[a-z][0-9]*#USB#g"`
		mount_as=`echo "$mount_output" | grep "${params[0]}" | sed 's/.*(\([a-z]*\),.*/\1/'`
		if [ "$mount_as" == "rw" ] ; then media_status=`echo "read-write"`; fi
		if [ "$mount_as" == "ro" ] ; then media_status=`echo "<b><font color=red>read-only</font></b>"`; fi
		# this is the first line, print table heading
		if [ $count -eq 0 ] ; then
			echo "<table $1>"
		echo "<tr><th>Device</th> <th>Size</th> <th>Used</th> <th>Available</th> <th>Use %</th> <th>Filesystem</th> <th>Status</th></tr>"
		fi
		echo "<tr><td>$media</td> <td align=right>${params[1]}</td> <td align=right>${params[2]}</td> <td align=right>${params[3]}</td> <td align=right>${params[4]}</td> <td>$fstype</td> <td>$media_status</td></tr>"
		let count+=1
	done <<< "$listing"

	if [ $count -eq 0 ] ; then
		echo "$2"			# no entries -> print "no devices found"
	else
		echo "</table>"			# there was at least 1 entry -> close the table
	fi
}

function show_device_config()
{
	/sbin/uci show | sed '/application.ferdinand.config_password/d'
}


# prints the evaluation period time left
function print_time_left
{
	if [ -x /usr/bin/barix-print-time-left.sh ]; then
		/usr/bin/barix-print-time-left.sh
	else
		echo "Unlimited"
	fi
}

function print_license_status
{
        QIBA_VERSION=`cat /etc/qiba-version`
        VALUE=`qiba-spi-get-license.sh ${QIBA_VERSION:0:-29} | awk -F ' ' '{print $6 }'`
	if [ "$VALUE" != "" ]; then
		echo $VALUE
	else
		echo "No license installed"
	fi
}

function print_license_id
{
        QIBA_VERSION=`cat /etc/qiba-version`
        VALUE=`qiba-spi-get-license.sh ${QIBA_VERSION:0:-29} | awk -F ' ' '{print $2 }'`
	if [ "$VALUE" != "" ]; then
		echo $VALUE
	else
		echo "N/A"
	fi
}

function print_license_issue_date
{
        QIBA_VERSION=`cat /etc/qiba-version`
        VALUE=`qiba-spi-get-license.sh ${QIBA_VERSION:0:-29} | awk -F ' ' '{print $4 }'`
	if [ "$VALUE" != "" ]; then
		echo $VALUE
	else
		echo "N/A"
	fi
}

function print_license_features
{
        QIBA_VERSION=`cat /etc/qiba-version`
        VALUE=`qiba-spi-get-license.sh ${QIBA_VERSION:0:-29} | awk -F ' ' '{print $3 }'`
	if [ "$VALUE" != "" ]; then
		echo $VALUE
	else
		echo "N/A"
	fi
}

function print_license_signature
{
        QIBA_VERSION=`cat /etc/qiba-version`
	if /usr/bin/qiba-check-license ${QIBA_VERSION:0:-29} 1>/dev/null 2>/dev/null; then
		echo "Signature is valid"
	else
		echo "Invalid signature"
	fi
}
