# Barix Web UI 
# (c)2012 Barix AG
#
# Functions to handle device configuration.


# include UCI functions
. /lib/config/functions.sh

# ------------ localy defined functions -----------

# prints 2 radio input entries for a boolean configuration parameter <input...> <input...>
# $1 = configuration parameter (e.g. network.eth0.ipaddr)
# $2 = true label 
# $3 = false label
function form_print_radio()
{
	# print negative value
	echo -n "<input type=\"radio\" name=\"$1\" value=\"false\""
	if ! cfg_bool_is_true "$1" ; then echo -n " checked" ; fi
	echo ">$3"

	# print positive value
	echo -n "<input type=\"radio\" name=\"$1\" value=\"true\""
	if cfg_bool_is_true "$1" ; then echo -n " checked" ; fi
	echo ">$2"
}
