from subprocess import Popen, PIPE
from .common import *
from . import status as status
#from . import config as config
import json
import socket

programPid = None
udp_player_socket = None
PLAYER_UDP_IP = "127.0.0.1"

player_udp_port = None
ignoreStopFlag = None


def init_udp_player_socket(player_udp_port_arg, ignore_Stop_Flag_arg):
    global udp_player_socket
    global player_udp_port
    global ignoreStopFlag
    udp_player_socket = socket.socket(socket.AF_INET, # Internet
                         socket.SOCK_DGRAM) # UDP

    playerUdpPort = player_udp_port_arg
    ignoreStopFlag = ignore_Stop_Flag_arg



def udp_send_str(jsonStr):
    global playerUdpPort
    customLogger().debug("Send cmd to player: " + jsonStr + " Port: " + str(playerUdpPort)) 
    udp_player_socket.sendto(jsonStr, (PLAYER_UDP_IP, playerUdpPort))

# Send this JSON to UDP controlled player:
# {"priority": "1", "stream_ip": "224.1.1.1", "volume": "100", "source_type":
# "syn-apps", "port": "11001", "command_name": "start" }
def udp_player_start(oin):
    global programPid
    global udp_player_socket
    dicto =  {}
    dicto["command_name"] = oin.command_name
    dicto["stream_ip"] = oin.stream_ip
    dicto["port"] = oin.port
    dicto["volume"] = oin.volume
    dicto["priority"] = oin.priority
    # Identify the command as being a syn-apps command
    dicto["source_type"] = "syn-apps"
    # Convert to json
    jsonStr = json.dumps(dicto)
    # Send command over UDP
    udp_send_str(jsonStr)
    return success_xml

# Send this JSON to UDP controlled player:
# {"priority": 0, "stream_ip": "224.1.1.1", "volume": 0, "source_type":
# "syn-apps", "port": "11001", "command_name": "stop"}
def udp_player_stop(oin):
    global programPid
    global udp_player_socket
    global ignoreStopFlag
    if ignoreStopFlag  == True:
        customLogger().debug("Ignore stop for debugging purposes.") 
        return success_xml
    dicto =  {}
    dicto["command_name"] = oin.command_name
    dicto["stream_ip"] = oin.stream_ip
    dicto["port"] = oin.port
    dicto["volume"] = oin.volume
    dicto["priority"] = oin.priority
    # Identify the command as being a syn-apps command
    dicto["source_type"] = "syn-apps"
    # Convert to json
    jsonStr = json.dumps(dicto)
    # Send command over UDP
    udp_send_str(jsonStr)
    return success_xml

# Send this JSON to UDP controlled player:
# {"stream_ip": "224.1.1.1", "volume": "100", "source_type":
# "syn-apps", "port": "11001", "command_name": "start_background_music" }
def udp_player_start_background_music(oin):
    global programPid
    global udp_player_socket
    dicto =  {}
    dicto["command_name"] = oin.command_name
    dicto["stream_ip"] = oin.stream_ip
    dicto["port"] = oin.port
    #dicto["volume"] = oin.volume
    #dicto["priority"] = oin.priority
    # Identify the command as being a syn-apps command
    dicto["source_type"] = "syn-apps"
    # Convert to json
    jsonStr = json.dumps(dicto)
    # Send command over UDP
    udp_send_str(jsonStr)
    return success_xml

# Send this JSON to UDP controlled player:
# {"stream_ip": "224.1.1.1", "volume": "100", "source_type":
# "syn-apps", "port": "11001", "command_name": "stop_background_music" }
def udp_player_stop_background_music(oin):
    global programPid
    global udp_player_socket
    dicto =  {}
    dicto["command_name"] = oin.command_name
    dicto["stream_ip"] = oin.stream_ip
    dicto["port"] = oin.port
    #dicto["volume"] = oin.volume
    #dicto["priority"] = oin.priority
    # Identify the command as being a syn-apps command
    dicto["source_type"] = "syn-apps"
    # Convert to json
    jsonStr = json.dumps(dicto)
    # Send command over UDP
    udp_send_str(jsonStr)
    return success_xml
