import subprocess

def get_setting_from_uci_or_exception(setting_name):
    #cmd = "/usr/bin/uci -q get flexa_app.AppParam." + setting_name
    cmd = ["/usr/bin/uci", "-q", "get", setting_name]
    process = subprocess.Popen(cmd, shell=False, stdout=subprocess.PIPE)
    (output, err) = process.communicate()
    exit_code = process.wait()
    if exit_code != 0:
        raise Exception("")
    retVal = output
    return retVal

def commit_uci():
    #cmd = "/usr/bin/uci -q commit flexa_app"
    cmd = ["/usr/bin/uci", "-q", "commit"]
    process = subprocess.Popen(cmd, shell=False, stdout=subprocess.PIPE)
    (output, err) = process.communicate()
    exit_code = process.wait()
    if exit_code != 0:
        raise Exception("")

def set_setting_in_uci_and_commit_uci(setting_name, setting_value):
    #cmd = "/usr/bin/uci -q set flexa_app.AppParam." + setting_name + "=" + str(setting_value)
    cmd = ["/usr/bin/uci", "-q", "set", setting_name + "=" + str(setting_value)]
    process = subprocess.Popen(cmd, shell=False, stdout=subprocess.PIPE)
    exit_code = process.wait()
    if exit_code != 0:
        raise Exception("")
    commit_uci()

def set_setting_in_uci_without_commit(setting_name, setting_value):
    #cmd = "/usr/bin/uci -q set flexa_app.AppParam." + setting_name + "=" + str(setting_value)
    cmd = ["/usr/bin/uci" ,"-q", "set", setting_name + "=" + str(setting_value)]
    process = subprocess.Popen(cmd, shell=False)

def get_setting_from_uci_and_set_default_if_needed(setting_name, setting_default_value):
    try:
        setting_value = get_setting_from_uci_or_exception(setting_name)
    except:
        set_setting_in_uci_and_commit_uci(setting_name, setting_default_value)
        setting_value = get_setting_from_uci_or_exception(setting_name)
        commit_uci()
    return setting_value
