import socketserver
import threading
#from .config import *
from .common import *
from . import handler as  handler

TCP_PORT = 44444
#HOST= '127.0.0.1'
HOST= '0.0.0.0'

tcpServer = None
tcpServerThread = None

isrunning = False

# Synapps test tool we have with unknonwn version does not conform with with
# Synapps documentation version 1.1 Rev 3. The doc states the messages are XML
# and yet the test tool does not send XML
expectXMLBool = False

class MyTCPHandler(socketserver.BaseRequestHandler):
    def parseDataMemberReturnCompleteFlag(self):
        if "<IPDeviceExecute>" in self.data:
            if "</IPDeviceExecute>" in self.data:
                customLogger().debug("tcp_server Message complete")
                return True
        customLogger().debug("tcp_server Message NOT complete")
        return False

    def handle(self):
        global expectXMLBool
        self.data=""
        # self.request is the TCP socket connected to the client
        completeMessageFlag = False
        while True:
            try:
                customLogger().debug("tcp_server Call recv...")
                self.dataPart = self.request.recv(1024).strip()
                self.dataPart = self.dataPart.decode("utf-8")
                clientAddr = self.client_address[0]
                customLogger().debug(clientAddr + ":tcp_server data part: " + self.dataPart)
                if len(self.dataPart) == 0:
                    customLogger().debug("tcp_server Zero length msg received.")
                    break;
                # Concat 
                self.data = self.data + self.dataPart
                if expectXMLBool == True:
                    completeMessageFlag = self.parseDataMemberReturnCompleteFlag()
                    if completeMessageFlag == True:
                        break
                else:
                    completeMessageFlag = True 
                    break
            except:
                logException()
                break;
        if completeMessageFlag == True:
            customLogger().debug("tcp_server Request:" + self.data)
            try:
                response = handler.mainHandler(self.data)
                customLogger().debug("tcp_server Response: " + response)
                self.request.sendall(response.encode("utf-8"))
            except:
                logException()
                self.request.sendall(error_xml.encode("utf-8"))
        else:
            self.request.sendall(error_xml.encode("utf-8"))
    
def init_tcp_server(host=HOST, port=TCP_PORT):
    global tcpServer
    try:
        customLogger().info("Init TCP Server at " + str(host) + ":" + str(port))
        socketserver.TCPServer.allow_reuse_address = True
        tcpServer = socketserver.TCPServer((host, port), MyTCPHandler)
        return SUCCESS
    except:
        logException()
        return ERROR

def tcp_server_thread_func():
    global tcpServer
    customLogger().info("Starting TCP server...")
    tcpServer.serve_forever()

def start_tcp_server_thread():
    global tcpServerThread, isrunning
    tcpServerThread = threading.Thread(target=tcp_server_thread_func)
    tcpServerThread.daemon = True
    try:
        tcpServerThread.start()
        isrunning = True
        return SUCCESS
    except:
        logException()
        return ERROR
    

def start_tcp_server_and_do_not_return():
    tcp_server_thread_func()

def stop_tcp_server():
    global tcpServer, isrunning
    customLogger().info("Stopping TCP server...")
    # Tell the serve_forever() loop to stop and wait until it does.
    tcpServer.server_close()
    isrunning = False
        
