from subprocess import Popen, PIPE
from . import system_common as com
from .discovery import *
from .common import customLogger

class System_ipam:
    def get_own_ip(self):
        return com.get_own_ip_from_interface_name("eth0")
   
    def get_syn_apps_server_addrs(self):
        return get_syn_apps_server_addrs_ipam()

    def get_mac_addr(self):
        cmd = "qiba-spi-get-mac-address"
        process = Popen(cmd, stdout=PIPE, shell=True)
        (output, err_string) = process.communicate()
        exit_code = process.wait()
        if exit_code != 0:
            customLogger().error("Error in get_mac_addr.")
            return ""
        lines = output.decode("utf-8").split("\n")
        tokens = lines[0].split("=");
        mac = tokens[1]
        return mac

