from subprocess import Popen, PIPE

def get_own_ip_from_interface_name(interface_name):
    cmd = "ip address show dev " + interface_name + " scope global | awk '/inet / {split($2,var,\"/\"); print var[1]}'"
    process = Popen(cmd, stdout=PIPE, shell=True)
    (output, err_string) = process.communicate()
    exit_code = process.wait()
    if len(output) == 0:
        exit_code = 1
    output = output.decode("utf-8")
    output = output.replace("\n", "")
    output = output.replace("\r", "")
    return output, exit_code

def get_own_ip_with_mask():
    process = Popen(["ip -o -f inet addr show | awk '/scope global/ {print $4}'"], 
        stdout=PIPE, shell=True)
    (output, err_string) = process.communicate()
    exit_code = process.wait()
    if len(output) == 0:
        exit_code = 1
    output = output.decode("utf-8")
    output = output.replace("\n", "")
    output = output.replace("\r", "")
    return output, exit_code
