#!/usr/bin/python3
from . import registration as reg
from . import system_interface as si
import time
import re
from .common import *
from . import udp_server as srv
from . import config2 as config
#import player_iface as player
from . import audio_path_config as audioPathConfig
from .handler import handler_init
from .reboot import do_reboot
from . import tcp_server as tcp_server
from . import persistance as persistance
import flexa_uci

#import subprocess
#from subprocess import *
import subprocess as subprocess
#import Logger


if __name__ == "__main__":

    init_custom_logger()

    #Verify if HW type =68. If not set it and reboot device
    p = subprocess.Popen(["/usr/bin/qiba-spi-get-production-info.sh", "-w"], stdout=PIPE, shell=False)
    hwType = int(p.communicate()[0])
    #logger.info("IP-Speaker HW Type:{}".format(hwType))
    if(hwType != 68):
        #logger.info("Set IP-Speaker HW Type to 68 and reboot device...")
        subprocess.Popen(["/usr/bin/qiba-spi-set-production-info.sh", "-w", "68"], shell=False)
        subprocess.Popen(["reboot"])
        exit(0)

    subprocess.Popen(["alsactl", "restore"], shell=False)
    time.sleep(1)
    #subprocess.Popen(["/bin/sh", "/mnt/data/package/i2c-init.sh"], shell=False)
    #time.sleep(2)

    audioVolume = "{}".format(flexa_uci.uci_get("application.audio.volume"))
    audioVolume = int(re.sub('%', '', audioVolume))


    if audioVolume == 100:
        dbVolume = 0
    elif 90 <= audioVolume < 100:
        dbVolume = -2
    elif 80 <= audioVolume < 90:
        dbVolume = -5
    elif 70 <= audioVolume < 80:
        dbVolume = -10
    elif 60 <= audioVolume < 70:
        dbVolume = -15
    elif 50 <= audioVolume < 60:
        dbVolume = -20
    elif 40 <= audioVolume < 50:
        dbVolume = -25
    elif 30 <= audioVolume < 40:
        dbVolume = -30
    elif 20 <= audioVolume < 30:
        dbVolume = -50
    elif 10 <= audioVolume < 20:
        dbVolume = -70
    elif 0 <= audioVolume < 10:
        dbVolume = -100

    exec_params = "/bin/sh /mnt/data/package/i2c-init.sh {}".format(dbVolume)
    customLogger().info("Run i2c-init.sh with dbVolume:{}, volume:{}%".format(dbVolume,audioVolume))
    subprocess.Popen(exec_params, shell=True)
    time.sleep(2)

    customLogger().debug("Python Syn-apps version: " + config.firmwareVersion)

    si.init()

    # Publicize version
    persistance.set_persistent_setting_without_commit("flexa_app.AppParam.app_name", "Synapps")
    persistance.set_persistent_setting_without_commit("flexa_app.AppParam.version", config.firmwareVersion )

    #if si.system_is_ipam() == True:
    #    #Init RCA input
    #    audioPathConfig.config_rca_as_input()
    #    #Init silence playback and reboot if needed
    #    rebootNeeded = audioPathConfig.get_silent_playback_reboot_required()
    #    if rebootNeeded == True and config.enableRebootToApplySilentPlayback == True:
    #        customLogger().debug("Rebooting to apply silent playback...")
    #do_reboot(None)

    handler_init()

    reg.start_registration_thread()


    if config.CommandProtocol == "UDP":
        res = srv.init_udp_server()
        if res != SUCCESS:
            customLogger().info("Error initializing UDP server.")
            exit(1)

        srv.start_udp_server_thread()

    else:
        res = tcp_server.init_tcp_server()
        if res != SUCCESS:
            customLogger().info("Error initializing TCP server.")
            exit(1)
        tcp_server.start_tcp_server_thread()


    # To avoid the death of the threads and be
    # killable with SIGINT
    while True:
        time.sleep(20)
