import json
#import httplib
#from .config import *
#from .system_interface import *
import sys
import traceback
import requests
from .common import *
from . import system_common as com
import threading
from time import sleep
from . import status as status
from .system_interface import *
from .tcp_server import *


class RegistrationThread():
    
    def __init__(self, synAppsConfig, callback = None):

        self.registration_thread = threading.Thread(target=self.registration_thread, args=(synAppsConfig,callback,))
        self.registration_thread.daemon = True
        
        self.registration_string = self.create_registration_string(synAppsConfig)
        
        #self.syn_apps_server_ip_addrs = get_si().get_syn_apps_server_addrs()
        

    def start(self):
        self.registration_thread.start()

    def create_registration_string(self, synAppsConfig):
        own_ip, error = get_si().get_own_ip()

        if len(own_ip) == 0:
            customLogger().error(" could not get own IP.")
            return ""

        ip_with_mask, error = com.get_own_ip_with_mask()

        if len(ip_with_mask) == 0:
            customLogger().error(" could not get IP with mask.")
            return ""
        """
        if isrunning:
            status = "OK"
            errorCode = 0
        else:
            status = "NOT OK"
            errorCode = 1
        """
        status = "OK"
        errorCode = 0
            
        body =  "Manufacturer=" + synAppsConfig.NameOfManufacturer +\
                "&Model=" + synAppsConfig.Model + \
                "&IPAddress=" + own_ip + \
                "&MAC=" + get_si().get_mac_addr() + \
                "&Firmware=" + synAppsConfig.firmwareVersion + \
                "&APIVersion=" + synAppsConfig.apiVersion + \
                "&Status=" + status + \
                "&ErrorCode=" + str(errorCode) + \
                "&SupportOneWay=true" + \
                "&SupportTwoWay=false" + \
                "&AudioInputs=0" + \
                "&AudioOutputs=1" + \
                "&SupportGPI=0" + \
                "&SupportGPO=0" + \
                "&SupportImage=false" + \
                "&SupportImageHeight=0" + \
                "&SupportText=false" + \
                "&SupportXMLCommands=true" + \
                "&SupportTextLength=0" + \
                "&SupportTextColor=false" + \
                "&SupportStrobe=false" + \
                "&CommandPort=" + str(synAppsConfig.CommandPort) +\
                "&Protocol=" + synAppsConfig.CommandProtocol
        return body

    def send_registration(self, synAppsConfig):
        registration_path = "/sa-announce/api/saannounceapi.asmx/RegisterIpDevice"
        numberOfSuccessfulRegistrations = 0
        #body = create_registration_string()
        if len(self.registration_string) == 0:
            return ERROR
        customLogger().info("Capabilities to register: " + self.registration_string)
        headers = {"content-type": "application/x-www-form-urlencoded"}
        #addrs = get_si().get_syn_apps_server_addrs()

        synappsServerAddrList = []

        if synAppsConfig.synappsServerAddr == "auto":
            customLogger().info("Reading synapps server address from file...")
            try:
                f = open("/tmp/synapps_server_ip", "r")
                synappsServerAddrList.append(f.read().strip('\n'))
                f.close()
                customLogger().info("IP read: " + str(synappsServerAddrList))
            except FileNotFoundError:
                customLogger().info("File not accessible")
        else:
            synappsServerAddrList.append(synAppsConfig.synappsServerAddr)

        """
         if synAppsConfig.synappsServerAddrList == "auto":
            customLogger().info("Reading synapps server address from file...")
            if os.path.isfile('/tmp/synapps/server_ip'):
                f = open("/tmp/synapps/server_ip", "r")
                synappsServerAddrList.append(f.read().strip('\n'))
                f.close()
                customLogger().info("IP read: " + str(synappsServerAddrList))
            else:
                customLogger().info("File not accessible")
        else:
            synappsServerAddrList = synAppsConfig.synappsServerAddrList
        """

        for addr in synappsServerAddrList:
            customLogger().info("Syn-apps attempt registration with: " + addr)
            try:
                r = requests.post("http://" + addr + registration_path, data=self.registration_string, 
                    headers=headers, timeout=5)
                if r.status_code == 200:
                    # Strip the port and save address
                    status.set_ip_in_use(addr.split(":")[0])
                    customLogger().info ("Succedded registration with: " + status.get_ip_in_use())
                    numberOfSuccessfulRegistrations += 1
                else:
                    customLogger().info("Return code to registration attempt: " + str(r.status_code))
                    customLogger().info("Response to registration attempt: " + repr(str(r.text)))
                    pass
            except:   
                customLogger().info("Registration failed")
                logExceptionLite()
                pass
        if numberOfSuccessfulRegistrations > 0:
            return SUCCESS
        return ERROR

    def registration_thread(self, synAppsConfig, callback):
        time_to_sleep = synAppsConfig.heartbeatInterval
        slept_time = 0
        while signaled_to_exit == False: 
            result = self.send_registration(synAppsConfig)
            if callback is not None:
                callback(result)
            slept_time = 0
            # Sleep unless signaled to exit
            while slept_time < time_to_sleep and signaled_to_exit == False:
                sleep(1)
                slept_time += 1
