from . import system_interface as system
from . import uci as uci

the_settings =  {}

def get_persistent_setting_or_exception(setting_name):
    if system.system_is_ipam_bool == True:
        return uci.get_setting_from_uci_or_exception(setting_name)
    else:
        return the_settings[setting_name]

def commit_persistents():
    if system.system_is_ipam_bool == True:
        return uci.commit_uci()
    else:
        pass

def set_persistent_setting_and_commit(setting_name, setting_value):
    if system.system_is_ipam_bool == True:
        return uci.set_setting_in_uci_and_commit_uci(setting_name, setting_value)
    else:
        the_settings[setting_name] = setting_value

def set_persistent_setting_without_commit(setting_name, setting_value):
    if system.system_is_ipam_bool == True:
        return uci.set_setting_in_uci_without_commit(setting_name, setting_value)
    else:
        the_settings[setting_name] = setting_value

def get_persistent_setting_and_set_default_if_needed(setting_name, setting_default_value):
    if system.system_is_ipam_bool == True:
        return uci.get_setting_from_uci_and_set_default_if_needed(setting_name, setting_default_value)
    else:
        try:
            aux = the_settings[setting_name]
            return aux
        except:
            the_settings[setting_name] = setting_default_value
            return setting_default_value
        
