import shlex
from subprocess import Popen, PIPE
from .common import *
from . import status as status
#from . import config as config
import time
from . import system_interface as si
from . import player_iface as player_iface
from pybarix import ffmpegPlayer as FfmpegPlayer

mixer = None
audio_dev = None

ffmpegPlayer = None
current_playing = None

LIST_SIZE = 10
streamsList = None


def init_local_player():
    global mixer, audio_dev, streamsList, LIST_SIZE, ffmpegPlayer

    customLogger().debug("Initializing local player.")
    #if mixer == None and audio_dev == None:
    try:
        f = open("/etc/barix/soundcard.conf", 'r')
        lines = f.read().split('\n')
        mixer = ((lines[2].split('='))[1]).strip('\n')
        audio_dev = ((lines[1].split('='))[1]).strip('\n')
        f.close()
    except Exception as e:
        customLogger().error(e)
        mixer = "Line Out"
        audio_dev = "plug:dmixer"
   
    customLogger().debug("Using mixer: "+mixer)
    customLogger().debug("Using audio_dev: "+audio_dev)

    ffmpegPlayer = FfmpegPlayer.FfmpegControlPlayer()

    streamsList = [None] * LIST_SIZE

    customLogger().debug("Local player initialized.")

def set_volume(vol):
    global mixer, audio_dev
    if si.system_is_ipam_bool == True:
        if mixer == "Line Out":
            cmd = "/usr/bin/amixer -q -M -c 2 set '" + mixer + "' " + str(vol) + "%"
        else:
            cmd = "/usr/bin/amixer -q -M set '" + mixer + "' " + str(vol) + "%"
        #cmd = "/usr/bin/amixer set 'Line Out' " + str(volumeUpTo100Str) + "%"
        process = Popen(cmd, shell=True)
        customLogger().debug("Setting volume: " + cmd) 
        exit_code = process.wait()
        if exit_code == 0:
            customLogger().debug("Volume set successfully.")
        else:
            customLogger().error("Could not set volume.")

# Starts player independent of statuses
def player_start_helper(oin):
    customLogger().debug("player_start_helper: rtp://{}:{}".format(oin.stream_ip, oin.port))
    global ffmpegPlayer, current_playing, ffmpegPlayer, audio_dev
    set_volume(oin.volume)
    
    url = "rtp://{}:{}".format(oin.stream_ip, oin.port)
    if audio_dev is not None:
        ffmpegPlayer.startFFMPEG(url,audio_dev)
        current_playing = oin
    else:
        customLogger().error("Error during local player initialization: audioDev = None; cannot play")


# Stops player independent of statuses
def player_stop_helper():
    customLogger().debug("player_stop_helper")
    global ffmpegPlayer, current_playing
    ffmpegPlayer.stopFFMPEG()
    current_playing = None


# Starts player taking into account statuses
def local_player_start(oin):
    global streamsList, current_playing
    
    #if it is playing a stream with lowest priority, stop previous stream and play the new one
    if current_playing is not None and int(current_playing.priority) >= int(oin.priority):
        player_stop_helper()
        player_start_helper(oin)
    elif current_playing is not None and int(current_playing.priority) < int(oin.priority):
        customLogger().debug("Cannot play stream rtp://{}:{} because a stream with higher priority is playing rtp://{}:{}".format(oin.stream_ip, oin.port, current_playing.stream_ip, current_playing.port))
    else:
        #it is playing nothing, play this stream
        player_start_helper(oin)

    #add stream to list
    streamsList[int(oin.priority)] = oin

    return success_xml


# Stops player taking into account statuses
def local_player_stop(obj):
    global current_playing, LIST_SIZE, streamsList

    if obj.stream_ip == "0.0.0.0" and int(obj.port) == 0:
        player_stop_helper()

        # clear list
        streamsList = [None] * LIST_SIZE
        
        return success_xml

    #if it is playing, stop player
    elif current_playing is not None and current_playing.stream_ip == obj.stream_ip and current_playing.port == obj.port:
        prio = int(current_playing.priority)
        player_stop_helper()

        #check if it has another stream to play
        for i in range(prio+1, LIST_SIZE):
            customLogger().debug(i)
            customLogger().debug(streamsList[i])
            if streamsList[i] is not None:
                player_start_helper(streamsList[i])
                break

    for i in range(0, LIST_SIZE):
        if streamsList[i] is not None and streamsList[i].stream_ip == obj.stream_ip and streamsList[i].port == obj.port:
            #remove from list
            streamsList[i] = None

    return success_xml

"""
def local_player_start_background_music(obj):
    global nonePlayingStatus, foreGroundPlayingStatus, backGroundPlayingStatus, curStatus
    global backGroundMusicObj
    # Save URL for later
    backGroundMusicObj = player_iface.PlayerCommand()
    backGroundMusicObj.stream_ip = obj.stream_ip 
    backGroundMusicObj.port = obj.port
    backGroundMusicObj.volume = "70" 

    # Start background music only if no announcement is ongoing
    if curStatus == nonePlayingStatus: 
        player_start_helper(backGroundMusicObj)
        curStatus = backGroundPlayingStatus
        return success_xml
    elif curStatus == backGroundPlayingStatus:
        # Stop current background music
        player_stop_helper()
        # Start new background music
        player_start_helper(backGroundMusicObj)
        curStatus = backGroundPlayingStatus
        return success_xml
    else:
        customLogger().debug("Cannot start background music because an announcement is ongoing") 
        return error_xml

# Internal function. The server does not send a
# stop background music command
def local_player_stop_background_music(ignoredForNow):
    global nonePlayingStatus, foreGroundPlayingStatus, backGroundPlayingStatus, curStatus
    global backGroundMusicObj
    if curStatus == backGroundPlayingStatus:
        # Stop current background music
        player_stop_helper()
        curStatus = nonePlayingStatus
    backGroundMusicObj = None
    return success_xml
"""