from subprocess import Popen, PIPE
from .common import *

def play_identification_tone():
    try:
        f = open("/etc/barix/soundcard.conf", 'r')
        lines = f.read().split('\n')
        mixer = ((lines[2].split('='))[1]).strip('\n')
        audio_dev = ((lines[1].split('='))[1]).strip('\n')
        f.close()
    except Exception as e:
        customLogger().error(e)
        mixer = "Line Out"
        audio_dev = "plug:dmixer"
   
    customLogger().debug("Using mixer: "+mixer)
    customLogger().debug("Using audio_dev: "+audio_dev)

    cmd = "speaker-test -D "+audio_dev+" -t sine --frequency 800 -p 5000 -buffer 10000 --nloops 1" 
    process = Popen(cmd, shell=True)
    customLogger().debug("Executed: " + cmd) 
    process.wait()
    return success_xml

