import xml.etree.ElementTree as ET
from .common import *
from . import player_iface as player_iface
from .system_interface import get_si
#from . import config as config
from .identification_tone import play_identification_tone
from .reboot import do_reboot
from .status import *
from .local_player import *
from .udp_controlled_player import *

cmdToFuncMap = {
    "start": None,
    "stop" : None,
    #"start_background_music": None,
    #"stop_background_music": None,
    "reset": do_reboot,
    "test": play_identification_tone,
    "status" : do_status
}

useVlcFlag = None

def handler_init(useVlc, use_udp_controlled_player, player_udp_port, ignore_Stop_Flag, customCallback):
    global useVlcFlag

    useVlcFlag = useVlc

    if customCallback is not None:
        cmdToFuncMap["start"]                  = customCallback.onPaStart
        cmdToFuncMap["stop"]                   = customCallback.onPaStop
        #cmdToFuncMap["start_background_music"] = customCallback.onBgmStart
        #cmdToFuncMap["stop_background_music"]  = customCallback.onBgmStop
        return
        
    if use_udp_controlled_player == True:
        init_udp_player_socket(player_udp_port, ignore_Stop_Flag)
        cmdToFuncMap["start"]                  = udp_player_start
        cmdToFuncMap["stop"]                   = udp_player_stop
        #cmdToFuncMap["start_background_music"] = udp_player_start_background_music
        #cmdToFuncMap["stop_background_music"]  = udp_player_stop_background_music
    else:
        init_local_player()
        cmdToFuncMap["start"]                  = local_player_start
        cmdToFuncMap["stop"]                   = local_player_stop
        #cmdToFuncMap["start_background_music"] = vlc_player_start_background_music
        #cmdToFuncMap["stop_background_music"]  = vlc_player_stop_background_music

def verify_xml(xmlStr):
    element = ET.fromstring(xmlStr)
    #a = element.tag

def extract_full_cmd_str_from_xml_str(xmlStr):
    element = ET.fromstring(xmlStr)
    url = element.getchildren()[0].get("URL")
    url = "URL=\"" + url + "\""
    customLogger().debug("handler return URL: " + url)
    return url

def verify_scheme(inStr):
    if inStr == "RTPRx":
        return True
    elif inStr == "RTPMRx":
        return True
    #elif inStr == "MG-Background":
    #    return True
    else:
        return False

def remove_carry_returns(strIn):
    strIn = strIn.replace("\n", "")
    strIn = strIn.replace("\r", "")
    return strIn

def replace_source_ip_if_needed(oin):
    global useVlcFlag
    # Syn-apps test software sends the wrong IP. Replace IP by
    # the server IP for the udp-controlled-player to use
    own_url, err = get_si().get_own_ip()
    if oin.stream_ip == own_url:
        #customLogger().debug("Synapps server is sending a speaker IP. Replace it by server IP.") 
        if useVlcFlag == True:
            oin.stream_ip = "0.0.0.0" 
        else:
            oin.stream_ip = get_ip_in_use()
    return oin
    

# Parse this
# URL="RTPRx://x.x.x.x:pppp:vvv:P"
# URL="RTPMRx://x.x.x.x:pppp:vvv:P"
# URL="RTPTx://x.x.x.x:pppp:Stop"
# URL="RTPMTx://x.x.x.x:pppp:Stop"
# URL="MG-Background://239.1.1.1:1111"
# URL="Test"
# URL="Status"
# URL="StopBackgroundMusic:Id"
# URL="Reset"
# x.x.x.x IP address of the stream".
# pppp UDP port of the stream.
# vvv Volume of the stream 0-100 (0 = use current device setting).
# Only sent with receive commands.
# P Priority = 1(max) through 9 (min).
#def getObjFromCmdStr(strIn):
def execCmdRecv(strIn):
    customLogger().debug("handler getObjFromCmdStr: " + strIn) 
    # Extract the string in qutoes
    arr = strIn.split("\"")
    if len(arr) != 3:
        customLogger().error("Error. Expected URL=...") 
        return None
    strIn = arr[1]
    
    # Test command  has no arguments
    if strIn.upper() == "Test".upper():
        #obj = player_iface.PlayerCommand()
        #obj.command_name = "test"
        #return obj
        return cmdToFuncMap["test"]()

    # Status command has no arguments and the doc does not 
    # specify what to return
    if strIn.upper() == "Status".upper():
        #obj = player_iface.PlayerCommand()
        #obj.command_name = "status"
        return cmdToFuncMap["status"]()

    # Reset command has no arguments 
    if strIn.upper() == "Reset".upper():
        #obj = player_iface.PlayerCommand()
        #obj.command_name = "reset"
        return cmdToFuncMap["reset"]()

    """
    # The StopBackgroundMusic command is mentioned in the doc but not
    # implemented by the test tool...
    if "StopBackgroundMusic".upper() in strIn.upper():
        obj = player_iface.PlayerCommand()
        obj.command_name = "stop_background_music"
        return obj
    """

    # Break string to array of elements
    its = strIn.split(":")

    # Verification number of arguments
    if len(its) != 5 and len(its) != 4:
    #if len(its) != 5 and len(its) != 4 and len (its) != 3:
        customLogger().error("Wrong number of elements: " + strIn) 
        return None

    # Get main command, HTTP scheme, which is one from the list above
    scheme = its[0]

    # Verification command gate
    if verify_scheme(scheme) == False:
        customLogger().error("Not supported: " + strIn) 
        return None

    """
    # Parse background music
    if scheme == "MG-Background":
        obj = player_iface.PlayerCommand()
        obj.command_name = "start_background_music"
        obj.stream_ip = its[1].replace("//", "")
        obj.port = its[2]
        obj.volume = None
        obj.priority = None
        obj = replace_source_ip_if_needed(obj)
        return obj
    """
    """
    # Parse RTPMTx start/stop and RTPMTx start/stop
    if len(its) == 5:
        obj = player_iface.PlayerCommand()
        obj.command_name = "start"
        obj.stream_ip = its[1].replace("//", "")
        obj.port = its[2]
        obj.volume = its[3]
        obj.priority = its[4]
        obj = replace_source_ip_if_needed(obj)
        return obj
    elif len(its) == 4:
        if its[3].upper() != "Stop".upper():
            customLogger().error("Expected Stop.") 
            return None
        else:
            obj = player_iface.PlayerCommand()
            obj.command_name = "stop"
            aux = its[1].replace("//", "")
            obj.stream_ip = aux
            # Port
            aux = its[2]
            obj.port = aux
            return obj
    else:
        customLogger().error("Unexpected num of items: " + str(len(its))) 
        return None
    """
    if its[-1].upper() == "Stop".upper():
        if len(its) == 4:
            obj = player_iface.Stream()
            #obj.command_name = "stop"
            aux = its[1].replace("//", "")
            obj.stream_ip = aux
            obj.port = its[2]
            #return obj
            return cmdToFuncMap["stop"](obj)
        else:
            customLogger().error(its[0] + " message with unexpected num of items: " + str(len(its)))
            return None
    else:
        if len(its) == 5:
            obj = player_iface.Stream()
            #obj.command_name = "start"
            obj.stream_ip = its[1].replace("//", "")
            obj.port = its[2]
            obj.volume = its[3]
            obj.priority = its[4]
            #obj = replace_source_ip_if_needed(obj)
            return cmdToFuncMap["start"](obj)
        else:
            customLogger().error( its[0] + " message with unexpected num of items: " + str(len(its)))
            return None

"""
# runCmd return body of response
def runCmd(obj):
    func = cmdToFuncMap[obj.command_name]
    return func(obj)
"""
    
def mainHandler(strIn):
    cmd = None
    try:
        customLogger().debug("handler strIn: " + strIn) 
        verify_xml(strIn)
        strIn = extract_full_cmd_str_from_xml_str(strIn)
    except:
        customLogger().debug("Detected non-XML: " + strIn) 

    try:
        #obj = getObjFromCmdStr(strIn)
        #res = runCmd(obj)
        res = execCmdRecv(strIn)
        return res
    except:
        logException()
        return error_xml

