import subprocess


def uci_get(param_name):
    # print("=> uci get "+param_name)
    try:
        response = subprocess.check_output("uci get " + param_name, shell=True)
        response = str(response,'utf8')
    except:
        print("UCI entry not found: {}".format(param_name))
        response = ""

    return response.rstrip()


def uci_set(param_name, param_value):
    # print("=> uci set " + param_name + '="' + str(param_value).replace('"', '\\"') + '"')
    try:
        print("--> uci set " + param_name + '=\"' + str(param_value).replace('"', '\\"') + '\"')
        response = subprocess.check_output(
            "uci set " + param_name + '=\"' + str(param_value).replace('"', '\\"') + '\"', shell=True)
    except:
        response = ""

    return response.rstrip()


def uci_commit(section=None):
    try:
        if section:
            response = subprocess.check_output("uci commit " + section, shell=True)
            print("UCI commit section {}".format(section))
        else:
            response = subprocess.check_output("uci commit", shell=True)
            print("UCI commit ALL")
    except:
        response = None

    return response.rstrip()


# WARNING! This erases all section!!.
def erase_uci_section(section):
    try:
        print('Erasing UCI section: {}'.format(section))
        response = subprocess.check_output("uci show " + section, shell=True)
        if response == "":
            print('Such section does not exist')
            return

        uciSectionParams = response.split('\n')
        # uciSectionParams.pop(0) #remove first element which is the section name

        for index, element in enumerate(uciSectionParams):
            element = element.split('=', 1)[0]
            uciSectionParams[index] = element

        print('Erasing the following UCI entries: {}'.format(uciSectionParams))
        for element in uciSectionParams:
            if element != "":
                response = subprocess.check_output("uci delete " + element, shell=True)

        uci_commit()
        print('Section {} erased successfully'.format(section))

    except:
        print('Such section does not exist')


def create_uci_section(section):
    print('Creating UCI section: {}'.format(section))
    returnCode = subprocess.call(['uci', 'show', section])
    # print('return code: {}'.format(returnCode))

    if returnCode == 0:  # section exists
        print('Section {} already exists. Quitting.'.format(section))
    else:
        uci_set(section, 'section')
        uci_commit()
        print('Section {} created.'.format(section))

    # response = subprocess.check_output("uci show " + section, shell=True)
    # print 'response: {}'.format(response)
    # if 'uci: Entry not found' in response:
    #     print 'Section {} does not exist. Proceeding to create it...'.format(section)
    # else:
    #


if __name__ == "__main__":
    print("Put here some code...")
