from subprocess import Popen, PIPE
import logging
from logging.handlers import RotatingFileHandler
import traceback
import sys

SUCCESS = True
ERROR = False
signaled_to_exit = False
customLoggerObj = None

success_xml = """<IPDeviceExecute>
                <ExecuteItem Result="SUCCESS"/>
                </IPDeviceExecute>"""

error_xml = """<IPDeviceExecute>
                <ExecuteItem Result="ERROR"/>
                </IPDeviceExecute>"""

def customLogger():
    global customLoggerObj
    return customLoggerObj

def loga(msg):
    print("LOGGER: "+msg)
    Popen("logger "+msg, shell=True)

# Exclude some logs
class NoParsingFilter(logging.Filter):
    def filter(self, record):
        return not record.getMessage().startswith('tcp_server')

def init_custom_logger(useSysLogFlag, debugLevel):
    global customLoggerObj
    
    logLevel = logging.INFO

    if debugLevel  == "debug":
        print("Use debug level of messages")
        logLevel = logging.DEBUG
        
    customLoggerObj = logging.getLogger('syn-apps')
    customLoggerObj.setLevel(logLevel)
    
    #loggingFormat = '%(asctime)s %(name)s %(module)s.%(funcName)s: %(message)s'
    loggingFormat = '%(asctime)s  %(levelname)s  %(filename)s:%(lineno)s  %(message)s'
    
    if useSysLogFlag == True:
        #handler = logging.handlers.SysLogHandler(address = '/dev/log')
        rotHandler = RotatingFileHandler('/var/log/synapps.log', maxBytes=2*1024*1024, backupCount=5)
        formatter = logging.Formatter(loggingFormat)
        #handler.setFormatter(formatter)
        rotHandler.setFormatter(formatter)
        #customLoggerObj.addHandler(handler)
        customLoggerObj.addHandler(rotHandler)
    else:
        logging.basicConfig(level=logLevel, format=loggingFormat)
        
    customLoggerObj.info("Custom logger was configured.")

def logException():
    global customLoggerObj
    exc_type, exc_value, exc_traceback = sys.exc_info()
    lines = traceback.format_exception(exc_type, exc_value, exc_traceback)
    #lastLine = lines[len(lines) - 1]
    for line in lines:
        customLoggerObj.error(repr(line))

def logExceptionLite():
    global customLoggerObj
    exc_type, exc_value, exc_traceback = sys.exc_info()
    lines = traceback.format_exception(exc_type, exc_value, exc_traceback)
    lastLine = lines[len(lines) - 1]
    customLoggerObj.error(repr(lastLine))


