from subprocess import Popen, PIPE
from .common import *


def config_rca_as_input():
    #rca_config = "echo 0 >  /sys/class/gpio/gpio17/value"
    #aux=Popen(rca_config, shell=True)
    #aux.wait()
    pass

# Sometimes you might want to play a short file (like 9.mp3" from the Sonic IP or
# similar), or send informacast/synapps command to play short stream.
# 
# In this case you may hear just some clicks (starting up/closing the ALSA
# device) and part of the short file (if at all)
# 
# To solve this, we have the /usr/bin/qiba-aplay-loop.sh script that is started
# by qiba-board-setup script at boot. However, to start it successfully, the
# 
# application.audio.silent_playback uci -q variable must be set to the device to be
# used, ex "plug:dmix". For the Flexa image it is empty (not defined), so the
# silent loop is not started. So, to activate it, you have two options:
# 
# 1) when installing your flexa app, set this uci -q variable once, or
# 
# 2) run it from your app internally, ex. from Lua I do it like this to start it
# in the background:
# 
# local silence_playback = os.execute('/usr/bin/aplay -D"plug:dmix" -f S8
# /dev/zero > /dev/null 2>/dev/null &');
# 
# Next, you have to make sure to add "--alsa-audio-device plug:dmix" to the VLC
# starting options, otherwise it will fail with "Device busy" error



def get_silent_playback_reboot_required():
    return False

def get_silent_playback_reboot_required_cenas():
    customLogger().debug("Init silent playback.") 
    cmd = "uci -q get application.audio.silent_playback"
    process = Popen(cmd, shell=True, stdout=PIPE)
    (output, err) = process.communicate()
    exit_code = process.wait()
    if "plug:dmix" in output.decode("utf-8"):
        customLogger().debug("Silent playback was already set.") 
        return False
    else:
        # Set the setting
        customLogger().debug("Setting silent playback...") 
        cmd = "uci -q set application.audio.silent_playback='plug:dmix'"
        process = Popen(cmd, shell=True, stdout=PIPE)
        exit_code = process.wait()
        # Commit the setting
        cmd = "uci -q commit"
        process = Popen(cmd, shell=True, stdout=PIPE)
        exit_code = process.wait()
        return True
    







