class SynAppsConfig():

    def __init__(self, NameOfManufacturer="Barix", Model="IP Speaker", firmwareVersion="1.3.1", 
                    apiVersion="1.1", Host="0.0.0.0", CommandPort=44444, CommandProtocol="TCP", 
                    ignoreStopFlag=False, useVlc=True, useSysLogFlag=True, debugLevel="debug", 
                    use_udp_controlled_player=False, player_udp_port=9999, synappsServerAddr="auto",
                    heartbeatInterval=60):

        # data to register the device in the server
        self.NameOfManufacturer = NameOfManufacturer
        self.Model = Model
        
        self.firmwareVersion = firmwareVersion
        
        with open("/barix/info/VERSION") as file:
            self.firmwareVersion = file.read().strip('\n')
        
        self.apiVersion = apiVersion
        self.Host = Host
        self.CommandPort = CommandPort
        self.CommandProtocol = CommandProtocol
        
        self.ignoreStopFlag = ignoreStopFlag

        # If useSysLogFlag is True, logs are sent to syslog. 
        # If useSysLogFlag is False, logs are sent to stdout. 
        self.useSysLogFlag = useSysLogFlag

        self.debugLevel = debugLevel

        self.use_udp_controlled_player = use_udp_controlled_player
        self.player_udp_port = player_udp_port

        self.useVlc = useVlc

        self.synappsServerAddr = synappsServerAddr

        self.heartbeatInterval = heartbeatInterval

        print("NameOfManufacturer: " + self.NameOfManufacturer + \
                " Model: " + self.Model + \
                " firmwareVersion: " + self.firmwareVersion + \
                " apiVersion: " + self.apiVersion + \
                " Host: " + self.Host + \
                " CommandPort: " + str(self.CommandPort) + \
                " CommandProtocol: " + self.CommandProtocol + \
                " ignoreStopFlag: " + str(self.ignoreStopFlag) + \
                " useVlc: " + str(self.useVlc) + \
                " useSysLogFlag: " + str(self.useSysLogFlag) + \
                " debugLevel: " + self.debugLevel + \
                " use_udp_controlled_player: " + str(self.use_udp_controlled_player) + \
                " player_udp_port: " + str(self.player_udp_port) + \
                " synappsServerAddrList: " + str(self.synappsServerAddr) + \
                " heartbeatInterval: "+ str(self.heartbeatInterval))
                
