from . import common as common
from . import system_interface as si
from . import handler as handler
from . import registration
#from . import config as config
#from . import udp_server as udp_server
from . import tcp_server as tcp_server
from . import local_player as local_player
from . import SynAppsConfiguration as SynAppsConfiguration
from pybarix import ffmpegPlayer

class SynAppsDevice():

    SUCCESS_MSG = common.success_xml
    ERROR_MSG = common.error_xml


    def __init__(self, synAppsConfig):

        self.backGroundMusicObj = None
        self.audioDev = None

        self.synAppsConfig = synAppsConfig

        #initializing syn-apps logger
        common.init_custom_logger(self.synAppsConfig.useSysLogFlag, self.synAppsConfig.debugLevel)

        #initial configurations (get own IP addr, get synapps server addr,...)
        si.init()
        #self.si = SystemInterface()
        
        self.ffmpegPlayer = ffmpegPlayer.FfmpegControlPlayer()

        
    def createHandler(self, callback_functions=None):
        handler.handler_init( self.synAppsConfig.useVlc, self.synAppsConfig.use_udp_controlled_player, self.synAppsConfig.player_udp_port, self.synAppsConfig.ignoreStopFlag, callback_functions)

    def registerDevice(self, registrationCallback = None):
        #registers the device capabilities on the server
        #reg.start_registration_thread()
        self.reg = registration.RegistrationThread(self.synAppsConfig, registrationCallback)
        self.reg.start()

    def connect(self):
        """
        if serverType == "UDP":
            res = udp_server.init_udp_server(self.synAppsConfig.Host, self.synAppsConfig.CommandPort)
            if res != common.SUCCESS:
                #customLogger().info("Error initializing UDP server.")
                self.logger.log(LogLevel.INFO,"SYN_APPS_CLIENT: error initializing UDP server")
            udp_server.start_udp_server_thread()
        else:
        """
        #if self.synAppsConfig.CommandProtocol == "TCP":
        res = tcp_server.init_tcp_server(self.synAppsConfig.Host, self.synAppsConfig.CommandPort)
        if res != common.SUCCESS:
            #customLogger().info("Error initializing TCP server.")
            common.customLogger().error("Error initializing TCP server.")
        else:
            res = tcp_server.start_tcp_server_thread()
            if res != common.SUCCESS:
                #customLogger().info("Error initializing TCP server.")
                common.customLogger().error("Error starting TCP server.")
            else:
                common.customLogger().info("TCP server started successfully.")
        #else:
        #    common.customLogger().info(self.synAppsConfig.CommandProtocol)

    def stop_player(self):
        #vlc_player.player_stop_helper()
        self.ffmpegPlayer.stopFFMPEG()


    def start_player(self, stream_ip, stream_port, audioDev):
        #vlc_player.player_start_helper(command_configs, audioDev)
        url = "rtp://{}:{}".format(stream_ip, stream_port)
        self.ffmpegPlayer.startFFMPEG(url,audioDev)

    """    
    def getPlayerStatus(self):
        return vlc_player.curStatus

    def setPlayerStatus(self,status):
        vlc_player.curStatus = status
    """

    def disconnect(self):
        if self.synAppsConfig.CommandProtocol == "TCP":
            tcp_server.stop_tcp_server()