import subprocess
import alsaaudio

class NewTestTone(): 
    
    def __init__(self, audioFile = "/etc/barix/tone.wav"):
        
        self.audioFile = audioFile
        
        
    def execute(self,duration, audioDev, volume):
        
        nrepeat        = int(int(duration)/60)
        d              = int(duration)%60
        device_name    = "-D"+audioDev
        
        
        audioChannel = audioDev.split(':')[1]
        #adjust volume
        m = alsaaudio.Mixer(audioChannel)
        
        #save previous vol config
        prevVol = m.getvolume()[0]
        
        #set volume to play test tone
        m.setvolume(int(volume))
        
        while nrepeat > 0:
            #print(nrepeat)
            proc = subprocess.Popen(["aplay", device_name, self.audioFile], shell=False)
            proc.wait()
            nrepeat-=1;
        proc = subprocess.Popen(["aplay", device_name, "-d", str(d), self.audioFile], shell=False)
        proc.wait()
        
        #restore previous volume
        m.setvolume(prevVol)
        
