import subprocess
import logging
import shlex
import re
import socket
import struct
import time
import threading
from logging.handlers import RotatingFileHandler

class FfmpegControlPlayer():

    #channel -> AudioDev
    def __init__(self):
        
        self.ffmpeg_proc = None
        
        self.customLogger = None
        
        #initiating logger
        self.initLogger()
        
        self.exec_command = None
        self.stopCommand = None

        self.streamURL = None
        self.audioDev = None



    def startFFMPEG(self, streamURL, audioDevice):
        self.customLogger.debug("Start FFMPEG")
        self.streamURL = streamURL
        self.audioDev = audioDevice
        self.stopCommand = False

        #self.launchFFMPEG(self.streamURL, self.audioDev)
        #(saddr, sport, stype) = self.divideStreamURL(streamURL)
        #self.customLogger.debug("Divide result:{} {} {}".format(saddr, sport, stype))
        #time.sleep(10)
        #self.customLogger.debug("calling monitoring")
        #self.startMonitoring(saddr, sport, stype)
        t = threading.Thread(target=self.launchFFMPEG, args=(streamURL,audioDevice,))
        t.start()
       


    def stopFFMPEG(self):
        #global ffmpeg_proc
        #global customLogger

        if self.ffmpeg_proc is not None:
            self.customLogger.debug("Killing ffmpeg running process.")
            self.ffmpeg_proc.kill()
            #self.ffmpeg_proc.send_signal(2)
            self.ffmpeg_proc = None
        self.stopCommand = True
        self.streamURL = None
        self.audioDev = None

    """
    def divideStreamURL(self, streamURL):
        #self.customLogger.debug("streamURL:{}".format(streamURL))
        match = re.search(re.compile(r"^rtp://@(\d+)$"),streamURL)
        if match:
            ipAddress = "127.0.0.1"
            port = int(match.group(1))
            rtpType = "Unicast"
        else:
            match = re.search(re.compile(r"^rtp://(\d+)\.(\d+)\.(\d+)\.(\d+)(:|@)(\d+)$"),streamURL)
            ipAddress = "{}.{}.{}.{}".format(match.group(1), match.group(2), match.group(3), match.group(4))
            port = int(match.group(6))
            if match.group(5) == "@" or ipAddress == "127.0.0.1":
                rtpType = "Unicast"
            else:
                rtpType = "Multicast"

        #self.customLogger.debug("result:{} {} {}".format(ipAddress, port, rtpType))
        return (ipAddress, port, rtpType)
    

    def startMonitoring(self, stream_addr, stream_port, stream_type):
        self.customLogger.debug("Start monitoring {} {} {}".format(stream_addr, stream_port, stream_type))
        #isAlive = False

        # create socket to monitor if stream is still alive
        sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM, socket.IPPROTO_UDP)
        sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        sock.bind((stream_addr, stream_port))

        #self.customLogger.debug("boooooom")

        if stream_type == "Multicast":
            self.customLogger.debug("is multicast")
            #join channel
            mreq = struct.pack("4sl", socket.inet_aton(stream_addr), socket.INADDR_ANY)
            sock.setsockopt(socket.IPPROTO_IP, socket.IP_ADD_MEMBERSHIP, mreq)

            #half second
            sock.settimeout(0.1)
            self.customLogger.debug("stopCommand {}".format(self.stopCommand))
            # while it is not suppose to stop playing
            while not self.stopCommand:
                self.customLogger.debug("Monitoring")
                try:
                    packet = sock.recv(8192)
                    flags, payload_type = struct.unpack('!BB', packet[0:2])
                    self.customLogger.debug(payload_type&0x7f)
                    if (payload_type&0x7f)<35: # it's alive
                        #if not isAlive:
                        self.customLogger.debug("Stream {}:{} is ALIVE!".format(stream_addr,stream_port))
                        #isAlive=True
                        # check if ffmpeg process is running to that stream
                        command = "ps aux | grep \"{}\" | grep -v \".*grep {}\"".format(self.exec_command, self.exec_command)
                        result = subprocess.run(shlex.split(shlex.quote(command)), capture_output=True, shell=True)
                        if result.returncode == 0:
                            self.customLogger.debug("Ffmpeg process is Running")
                        else:
                            self.customLogger.debug("Ffmpeg process is not Running")
                            self.launchFFMPEG(self.streamURL, self.audioDev)
                except socket.timeout:
                    #if isAlive:
                    self.customLogger.debug("Stream {}:{} is DEAD!".format(stream_addr,stream_port))
                    self.stopCommand = True
                time.sleep(1)
    """
    def launchFFMPEG(self, streamURL, audioDevice):
        """
        self.exec_command = "/usr/bin/ffmpeg -i {} -f alsa {}".format(streamURL,audioDevice)
        self.customLogger.debug("Executting command {}.".format(self.exec_command))
        self.ffmpeg_proc = subprocess.Popen(shlex.split(self.exec_command), shell=False)
        """
        while not self.stopCommand:
            self.exec_command = "/usr/bin/ffmpeg -i {} -f alsa {}".format(streamURL,audioDevice)
            self.customLogger.debug("Executting command {}.".format(self.exec_command))
            self.ffmpeg_proc = subprocess.Popen(shlex.split(self.exec_command), shell=False)
            self.ffmpeg_proc.wait()
            """
            #self.customLogger.debug("Ffmpeg process has finished with error code {}".format(self.ffmpeg_proc.returncode))
            #self.customLogger.debug(self.finishedCallback is not None)
            if self.ffmpeg_proc is not None: #process wasn't kill in the meantime
                # A None value indicates that the process hasn’t terminated yet.
                # A negative value -N indicates that the child was terminated by signal N (POSIX only)
                if callback is not None and self.ffmpeg_proc.returncode is not None and self.ffmpeg_proc.returncode >= 0:
                    command = "ps aux | grep \"{}\" | grep -v \".*grep {}\"".format(self.exec_command, self.exec_command)
                    result = subprocess.run(shlex.split(shlex.quote(command)), capture_output=True, shell=True)
                    self.customLogger.debug(result.stdout)
                    self.customLogger.debug("Returning callback")
                    callback()
            """


    def initLogger(self):        
            
        self.customLogger = logging.getLogger('ffmpeg')
        
        logLevel = logging.DEBUG
        self.customLogger.setLevel(logLevel)
        
        rotHandler = RotatingFileHandler('/var/log/ffmpeg.log', maxBytes=2*1024*1024, backupCount=5)
        
        loggingFormat = '%(asctime)s  %(levelname)s  %(filename)s:%(lineno)s  %(message)s'
        formatter = logging.Formatter(loggingFormat)
        
        rotHandler.setFormatter(formatter)
        self.customLogger.addHandler(rotHandler)
        
        self.customLogger.debug("Ffmpeg custom logger configured")
