import json
import os

class InformaCastConfig():

    def __init__(self, sysLogProtocol="/var/log/informacast.log", sysLogServer="", workDir="./", 
                    sendDevLogsToSyslog="true", SpeakerPortNumber=9191, PlayerUDPPort=0,
                    ServerURL="auto", IdleAddr=None, IdlePort=None, IdleFormat = None, IdleVol = None):
        
        self.sysLogProtocol = sysLogProtocol
        self.sysLogServer = sysLogServer
        self.workDir = workDir
        self.sendDevLogsToSyslog = sendDevLogsToSyslog
        self.SpeakerPortNumber = SpeakerPortNumber
        self.PlayerUDPPort = PlayerUDPPort
        self.url = ServerURL
        self.idleAddr = IdleAddr
        self.idlePort = IdlePort
        self.idleFormat = IdleFormat
        self.idleVol = IdleVol
        
        fconfigs = { "sysLogProtocol" : self.sysLogProtocol,
                    "sysLogServer" : self.sysLogServer,
                    "workDir" : self.workDir,
                    "sendDevLogsToSyslog" : self.sendDevLogsToSyslog,
                    "SpeakerPortNumber" : self.SpeakerPortNumber,
                    "PlayerUDPPort" : self.PlayerUDPPort}

        print(fconfigs)
        #path = os.path.dirname(os.path.realpath(__file__))
        #self.configFile = path + "/informacast.conf"
        os.makedirs("/tmp/informacast/", exist_ok=True)
        self.configFile = "/tmp/informacast/informacast.conf"
        print(self.configFile)
        f = open(self.configFile, "w")
        f.write(json.dumps(fconfigs))
        f.close()
