import os
import subprocess
import re
import socket
import struct
from threading import *
from . import InformaCastConfig
from pybarix import ffmpegPlayer, testTone
import xml.etree.ElementTree as ET

class InformaCastDevice():

    """
    NONE_PLAYING_STATUS = 1
    ANNOUNCE_PLAYING_STATUS = 2
    BGM_PLAYING_STATUS = 3
    """

    """
    SUCCESS_MSG = common.success_xml
    ERROR_MSG = common.error_xml
    """


    def __init__(self, config):

        self.config = config

        self.curURL = None
        self.curAudioDev = None
        
        #configure ffmpegPlayer
        self.ffmpegPlayer = ffmpegPlayer.FfmpegControlPlayer()

        #configure Informacast
        infoCastConfig = self.configureInformaCast()
        
        #lauch main-informacast process
        self.info_proc = subprocess.Popen(infoCastConfig, shell=False)      
        

    def configureInformaCast(self):        
        #just to make sure
        subprocess.Popen(["chmod","+x","/etc/barix/main-informacast"],shell=False)

        args = ["/etc/barix/main-informacast","-c",self.config.configFile]

        if self.config.PlayerUDPPort != 0:
            args.append("-use_udp_controlled_player")

        if self.config.url == "auto":
            args.append("-enable_discovery_process")
        else:
            info_dft_conf = self.createDefaultConfigFile()
            args.extend(["-d",info_dft_conf])

        #args = self.configure()
        return args
        

    def createDefaultConfigFile(self):
                   
        defaultConfigPath = "/tmp/informacast/DefaultInformaCastSpeaker.cfg"

        try:
            root = ET.Element("InformaCastSpeakerConfiguration")
            servers = ET.SubElement(root, "Servers")

            url = self.config.url + "?cmd=spkr"

            ET.SubElement(servers, "InformaCast", url=url)

            if self.config.idleAddr is not None and self.config.idlePort is not None and self.config.idleFormat is not None and self.config.idleVol is not None:

                idleAudio = ET.SubElement(root, "IdleAudio", address=self.config.idleAddr, port=str(self.config.idlePort), format=self.config.idleFormat, volume=str(self.config.idleVol))

            tree = ET.ElementTree(root)
            tree.write(defaultConfigPath)

        except Exception as e:
            print(e)

        return defaultConfigPath
    
    """
    
    def start_stream(self, url, audioDev):
        self.start_player(url, audioDev)
        self.url = url
        self.audioDev = audioDev
    
    def stop_stream(self,url, audioDev):
        
        #if stream corresponds to the one currently playing
        self.stop_player()
        
    """
    
    def stop_player(self):
        self.ffmpegPlayer.stopFFMPEG()
        self.curURL = None
        self.audioDev = None


    def start_player(self, addr, port, audioDev):
        url = self.buildURL(addr, port)
        
        self.curURL = url
        self.curAudioDev = audioDev
        
        self.ffmpegPlayer.startFFMPEG(self.curURL,self.curAudioDev)
    

        
        
    def testCmd(self, audioDev, duration, volume):
        
        """
        nrepeat = int(int(duration)/60)
        d = int(duration)%60
        device_name = "-D"+audioDev
        """
        
        #stop player
        self.ffmpegPlayer.stopFFMPEG()
        """
        #test
        while nrepeat > 0:
            print(nrepeat)
            proc = subprocess.Popen(["aplay", device_name, "/etc/barix/tone.wav"], shell=False)
            proc.wait()
            nrepeat-=1;
        proc = subprocess.Popen(["aplay", device_name, "-d", str(d), "/etc/barix/tone.wav"], shell=False)
        proc.wait()
        """
        test = testTone.NewTestTone()
        test.execute(duration, audioDev, volume)

        #start player with previous config
        if self.curURL is not None and self.curAudioDev is not None:
            self.ffmpegPlayer.startFFMPEG(self.curURL,self.curAudioDev)
        
    """
    def clear(self):
        self.stop_player()
        #return msg
    """
    
    
            
      
    """
    def sendResponse():
        pass
    """
    """
    def divideURL(self, url):
        match = re.search(re.compile(r"^rtp://(\d+)\.(\d+)\.(\d+)\.(\d+)(:|@)(\d+)$"),url)
        ipaddr = "{}.{}.{}.{}".format(match.group(1), match.group(2), match.group(3), match.group(4))
        port = int(match.group(6))
        return (ipaddr, port)
    """
    
    def buildURL(self, addr, port):
        url = "rtp://"+addr+":"+str(port)
        return url
    
    def disconnect(self):
        try:
            self.stop_player()
            self.info_proc.kill()
        except Exception as e:
            return e
