#!/bin/sh

error_exit() {
  echo "Error: $1" 1>&2
  exit 1
}

if ! qiba-spi-get-info >/tmp/json 2>/dev/null; then
  error_exit "cannot retrieve production info from SPI flash"
fi

if sed 's/\"SW_LICENSES\":\s\[[^]]*\]/\"SW_LICENSES\":\ [ \]/g' -i /tmp/json; then
  if ! qiba-spi-set-info /tmp/json 1>&2 >/dev/null; then
    error_exit "cannot store production info into SPI flash"
  else
    echo "All licenses removed"
  fi
fi

exit 0
