#!/bin/sh

source /usr/bin/jshn.sh
export _json_no_warning=1

error_exit() {
  echo "Error: $1" 1>&2
  exit 1
}

print_usage() {
  echo "usage: $1 [<image_name>]"
  echo "Retrieve all the licences or the specified one:"
  echo "  <image_name>        is the optional associated image name" 
  exit 1
}

if [ "$#" -gt 1 ]; then
  print_usage $0
fi

IMAGE_NAME=$1

if ! qiba-spi-get-info >/dev/null 2>/dev/null; then
  HW_INFO="{ }"
else
  HW_INFO=`qiba-spi-get-info`
fi
json_load "$HW_INFO"

license_id=""
image_name=""
if json_select SW_LICENSES; then 
  Index="1"
  while json_get_type type $Index && [ "$type" = object ]; do
    json_select "$((Index++))"
    json_get_var license_id "License_ID"
    json_get_var image_name "Image_Name"
    json_get_var features "Image_Features"
    json_get_var issue "Issue_Date"
    json_get_var expire "Expire_Date"
    json_get_var status "Status"
    json_get_var signature "Signature"
    if [ "$IMAGE_NAME" = "" ] || [ "$image_name" = "$IMAGE_NAME" ]; then
      echo "$image_name $license_id $features $issue $expire $status $signature"
    fi
    json_select ".."
  done
fi

exit 0
