#!/bin/sh
ALSA_INT=`uci -q get application.audio.silent_playback`
if [ "$ALSA_INT" = "" ]; then
	echo "$0: No ALSA interface definition found. Quiting..."
	exit 0
fi	

echo "$0: ALSA interface is ALSA_INT=$ALSA_INT"
echo "$0: Starting /usr/bin/aplay -D"$ALSA_INT" -f S8 /dev/zero > /dev/null"
CNT=0
while true; do
	echo "$CNT" > /tmp/aplay_restore_cnt
	/usr/bin/aplay -D"$ALSA_INT" -f S8 /dev/zero > /dev/null 2>/dev/null
	echo "$0: aplay crashed on $CNT run, restarting it..."
	let CNT=CNT+1
done

