#!/bin/sh 

# This script is used to detect PoE Power
#
#   GPIO408         - gpio expander 0x26
#   IO2 / GPIO410   - TYP4 DET  -> IEEE802.3bt type 4
#   IO3 / GPIO411   - TYP3 DET  -> IEEE802.3bt type 3
#   IO4 / GPIO412   - AT DET    -> IEEE802.3at
#
#   If none of those is HIGH, but you are still powered by PoE -> this means you are running on IEEE802.3af
#
#   OBS: they are inverted, so "0" means HIGH
#       
#   Max theoretical availible power at PD from these standards:
#   IEEE802.3af ------------>  12.95 W
#   IEEE802.3at ------------>  25.50 W
#   IEEE802.3bt type 3 ----->  51    W
#   IEEE802.3bt type 4 ----->  71    W
#
#   V1.0
#


# TODO: Test if MPA400 is being run from PoE or from an external power 
#       Should only be possible on the next MPA400 revision!!


#Initialize all PoE inputs
if ! [ -d /sys/class/gpio/gpio410 ]; then
    echo "410" > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio410/direction
fi
if ! [ -d /sys/class/gpio/gpio411 ]; then
    echo "411" > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio411/direction
fi
if ! [ -d /sys/class/gpio/gpio412 ]; then
    echo "412" > /sys/class/gpio/export
    echo "in" > /sys/class/gpio/gpio412/direction
fi

#Read
TYP4_DET=`cat /sys/class/gpio/gpio410/value`
TYP3_DET=`cat /sys/class/gpio/gpio411/value`
AT_DET=`cat /sys/class/gpio/gpio412/value`

echo $TYP4_DET
echo $TYP3_DET
echo $AT_DET

#default values
poetype="PoE"
power=12.95

if [ "$TYP4_DET" = "1" ] && [ "$TYP3_DET" = "1" ] && [ "$AT_DET" = "1" ]
then
    echo "running on IEEE802.3af - max theoretical available power: 12.95W"
    poetype="PoE"
    power=12.95
else
    if [ "$AT_DET" = "0" ]; then
        echo "running on IEEE802.3at - max theoretical available power: 25.50W"
        poetype="PoE+"
        power=25.50
    else
        if [ "$TYP3_DET" = "0" ]; then
            echo "running on IEEE802.3bt type 3 - max theoretical available power: 51W"
            poetype="4PPoE"
            power=51
        else
            if [ "$TYP4_DET" = "0" ]; then
                echo "running on IEEE802.3bt type 4 - max theoretical available power: 71W"
                poetype="PoE type4"
                power=71
            else
                echo "unknown running mode!!"
            fi
        fi
    fi
fi


#Store result in /tmp/poe-detect
echo "poe.type=$poetype" > /tmp/poe-detect
echo "poe.power=$power"  >> /tmp/poe-detect
