#!/bin/sh
#
# Generate Service for IP-Speaker Discovery
#
##########################################

source /usr/bin/jshn.sh

FACTORY_INFO_JSON=/tmp/factory_info_partition/factory_info_json
SERVICE_XML_FILE=/etc/avahi/services/discovery.service
MANIFEST_JSON=/mnt/data/package/manifest.json

MAC_ADDRESS=`cat /sys/class/net/eth0/address`

HW_INFO=`cat $FACTORY_INFO_JSON`
json_load "$HW_INFO"
json_select HW_DEVICE

json_get_var IPAM_NAME "IPAM_Name"
json_get_var IPAM_TYPE "Legacy_IPAM_Type"
json_get_var HW_TYPE "Legacy_HW_Type"


if [ -f $MANIFEST_JSON ]
then	
	MANIFEST_INFO=`cat $MANIFEST_JSON`
	json_load "$MANIFEST_INFO"
	json_get_var SERVICE_NAME "name"
else 
	SERVICE_NAME=$(/usr/bin/uci get application.main_config.active_app)
fi

FW_VERSION=`cat /barix/info/VERSION`

{
	echo "<?xml version=\"1.0\" standalone='no'?><!--*-nxml-*-->"
	echo "<!DOCTYPE service-group SYSTEM \"avahi-service.dtd\">"
	echo " "
	echo "<service-group>"
	echo " "
	echo "<name>$SERVICE_NAME|$MAC_ADDRESS|</name>"
  	echo " "
	echo "<service>"
    	echo "	<type>_https._tcp</type>"
    	echo "	<port>443</port>"
    	echo "	<txt-record>IPAM=$IPAM_NAME</txt-record>"
      echo "	<txt-record>TYPE=$IPAM_TYPE</txt-record>"
      echo "	<txt-record>HW_TYPE=$HW_TYPE</txt-record>"
      echo "	<txt-record>FW_VERSION=$FW_VERSION</txt-record>"
 	echo " </service>"
	echo " "
	echo "</service-group>"
} > $SERVICE_XML_FILE 

