#!/bin/sh

LED1_GREEN=/sys/class/leds/barix\:led1\:green
LED1_RED=/sys/class/leds/barix\:led1\:red

led1_blink() {
  if [ -d $LED1_GREEN ]; then
    echo "timer" > $LED1_GREEN/trigger
    echo "100" > $LED1_GREEN/delay_on
    echo "100" > $LED1_GREEN/delay_off
  elif  [ -d $LED1_RED ]; then
    echo "timer" > $LED1_RED/trigger
    echo "100" > $LED1_RED/delay_on
    echo "100" > $LED1_RED/delay_off
  fi
}

if [ -d /barix/local/config ]; then
  logger -p local0.alert "Restoring default configuration and rebooting ..."
  led1_blink
  rm -rf /barix/local/config
  rm -rf /barix/local/etc
  rm -rf /barix/local/app-data
  for HOOK in /barix/hooks/app-config/*
  do
      $HOOK restore-defaults
  done
  /sbin/reboot &
fi
