##################################################################################
#
#	asound.conf generator script
# 
#     	Board support: 
#                   	-> M400 		(54)
#		    	-> TPA400		(66)
#		    	-> USSI_ENC_CTRL	(68)
#			-> MPA400		(69)
##################################################################################

ASOUND_CONF_IN=/etc/asound.conf.in
ASOUND_CONF=/etc/asound.conf
APP_SOUND_CONF=/etc/barix/app-sound.conf

##################################################################################

# set Barix Main softvol on top of a specific pcm:
# - analog_out
# - digital_out
set_pcm_out(){

cat >> $ASOUND_CONF <<EOF

# Master Volume Control
pcm.master_soft {
    type softvol
    slave.pcm "$1"
    control {
        name "BARIX_MAIN"
        card 0
    }
}

pcm.master1 {
    type plug
    slave.pcm "master_soft"
}

pcm.!default {
    type asym
    playback.pcm "plug:$1"
    capture.pcm "plug:dsnooper"
}

#defaults.pcm.rate_converter “samplerate_medium”

EOF
}

# set Barix Main softvol on top of multi card configuration
# multi card using digital_out and analog_out
set_both_out(){

cat >> $ASOUND_CONF <<EOF

# quad channel card containing both cards
pcm.quad {
    type multi
    slaves.a.pcm "digital_out"
    slaves.a.channels 2
    slaves.b.pcm "loopback_out"
    slaves.b.channels 2
    bindings.0 { slave a; channel 0; }
    bindings.1 { slave a; channel 1; }
    bindings.2 { slave b; channel 0; }
    bindings.3 { slave b; channel 1; }
}

# Stereo2Quad (both_out) routing device. It just takes the stereo input,
# and replicates it on the two channels of H3 Codec and I2S cards
# the last 6 chans of the i2s are not used
pcm.both_out {
    type route
    slave.pcm quad
    ttable.0.0 1
    ttable.1.1 1
    ttable.0.2 1
    ttable.1.3 1
}

EOF
     set_pcm_out "both_out"
}



#load base configuration
if [ -f $ASOUND_CONF_IN ]; then
	cat $ASOUND_CONF_IN > $ASOUND_CONF
fi

#set hw_type specific configuration
HW_TYPE=$(/usr/bin/qiba-spi-get-production-info.sh -w)

case "$HW_TYPE" in
    "66")
      set_pcm_out "digital_out"
      ;;

    "69")
      set_both_out
      ;;

     *)
      set_pcm_out "analog_out" 
     ;;
esac

# append APP asound specific configuration
if [ -f $APP_SOUND_CONF ]; then
	cat $APP_SOUND_CONF >> $ASOUND_CONF
fi
