#!/bin/sh
#Production speaker test sound for Barix FW images                             

FACTORY_INFO_PATH=/tmp/factory_info_partition
FACTORY_INFO_FILE=$FACTORY_INFO_PATH/factory_info
FACTORY_INFO_JSON_FILE=$FACTORY_INFO_PATH/factory_info_json

HW_INFO=`cat $FACTORY_INFO_JSON_FILE`

TEST_STATUS=$(echo "$HW_INFO" | jq '.HW_TEST.Status' | tr -d \")

if ! [ -z $TEST_STATUS ]; then                                                 
	if [ $TEST_STATUS = "2" ]; then                                        
		# Debug issue when config is not properly set-up                      
		# by playing white noise sound
		if [ -s /mnt/data/local/config/network ]; then                        
			echo "Running speaker test ..."                               
			/usr/bin/qiba-speaker-test.sh &                               
			/usr/bin/qiba-spi-set-production-info.sh -t 3                 
		else                                                                  
			echo "Playing white noise to announce error ..."                               
			/usr/bin/speaker-test >/dev/null &                            
		fi                                                                    
	fi                                                                            
fi 
