#!/bin/sh
# 
# Set Volume:
# -> Master softvol (BARIX_MAIN)
# -> Analog card ("2") : 'Line Out' and 'DAC' mixers'
#

#set softvol
SOUND_CARD_CONF=/etc/barix/soundcard.conf
MASTER_DEVICE=$(cat $SOUND_CARD_CONF | grep "master.device" | sed -e 's/master.device\s*=\s*//')
MASTER_CONTROL=$(cat $SOUND_CARD_CONF | grep "master.control" | sed -e 's/master.control\s*=\s*//')
VOLUME=$(/usr/bin/uci get application.audio.volume)
/usr/bin/aplay -D"$MASTER_DEVICE" teste.wav
/usr/bin/amixer -q -M set $MASTER_CONTROL $VOLUME%

#set analog card volume
/usr/bin/amixer -q -M -c 2 set 'Line Out' 100%
/usr/bin/amixer -q -M -c 2 set 'DAC' 70%

/usr/sbin/alsactl store
